<?php

	require_once('config.php');
	require_once('sysclub_class/grid.php');
	require_once('sysclub_class/mensagem.php');
	require_once('sysclub_class/clientewebservice.php');
	require_once('sysclub_class/clientewebservice.php');
	require_once('sysclub_functions/functions.php');
	require_once('seguranca.php');

	switch ($action) 
	{
		default : index();
	}

	function index()
	{
		global $CLUBE, $TITULO_SITE;
		
		$codigo = $_SESSION["CODIGO"];
		$mesano = Get("mesano");
		$mes = substr($mesano, 0, 2);
		$ano = substr($mesano, 3, 4);

		try
		{
			$factory = new WebService();
			$result = $factory->GetDadosFinanceiroMensalDetalhado($codigo, $mesano);
		}
		catch (Exception $e) 
		{
			$mensagem = new Mensagem();
			$conteudo = $mensagem->Make('Servi&ccedil;o de Boleto ON-LINE n&atilde;o esta dispon&iacute;vel...');
			include("view/template.php");
			exit;
		}
				
		$conteudo = "
					

		<div class='row'>
			<div class='col-md-10'><h2>Extrato mensal ". $mes ."/". $ano ."</h2></div>
			<div class='col-md-2'></div>
		</div>

		<div class='row'>
			<div class='col-md-12'>
				<div class='row'>
					<div class='col-sm-8'>
						<label>Nome</label><br>
						<span>". $result[0]['NM_ENTIDADE'] ."</span>
					</div>
					<div class='col-sm-2'>
						<label>Matricula</label><br>
						<span>". $result[0]['NR_COTA'] ."</span>
					</div>
				</div>

			</div>
			<div class='col-md-2'></div>
		</div>

		<div class='row'>
			<div class='col-md-12'>

					<table class=\"table table-striped table-bordered\" id=\"listing\">
						<thead>
							<tr>
								<th class='col-md-2'>Codigo</th>
								<th class='col-md-8'>Operacao</th>
								<th class='col-md-2'>Valor</th>
							</tr>
						<thead>
						<tbody>";

						$total = 0.0 ;

						foreach($result as $row)
						{
							$total = $total + $row['VALOR'] ;

		$conteudo .= "
						<tr>
							<td>". $row['CD_CONTA'] ."</td>
							<td>". $row['NM_CONTA'] ."</td>
							<td><span class='pull-right'>". number_format($row['VALOR'], 2, '.', ',') ."</span></td>
						</tr>";

					}

		$conteudo .= "
						<tr>
							<td colspan='2'><label>Total</label></td>
							<td><span class='pull-right'><label>". number_format($total, 2, '.', ',') ."</label></span></td>
						</tr>";


		$conteudo .= "
						</tbody>
					</table>
			</div>
			<div class='col-md-1'></div>
		</div>

		<div class='row hidden-print'>
			<div class='col-md-12'>
					<a href='extratoperiodo.php' class='btn btn-default'>
						<span class='glyphicon glyphicon-chevron-left'></span> Voltar 
					</a>
					<a href='javascript:window.print();' class='btn btn-success'>
						<span class='glyphicon glyphicon-print'></span> Imprimir 
					</a>
			</div>
		</div>

		";

		include("view/template.php");
	}

?>