<?php

	require_once('config.php');
	require_once('sysclub_functions/functions.php');
	require_once('sysclub_class/grid.php');
	require_once('sysclub_class/mensagem.php');
	require_once('sysclub_class/clientewebservice.php');

	$action = Get("action");

	switch ($action) 
	{
		case "imprimir":
			imprimir();
			break;
		case "teste":
			teste();
			break;
		default : 
			error();
	}

	function teste()
	{
		$mensagem = new Mensagem();
		$mensagem->time = 60000;
		$conteudo = $mensagem->Make("Teste");
		include("view/template.php");
	}
	
	function error($messagem)
	{
		$mensagem = new Mensagem();
		$mensagem->redirect = "extrato.php?action=index";
		$mensagem->time = 60000;
		$conteudo = $mensagem->Make("Ocorreu um erro gerando o boleto! <br><br>Error: $messagem");
		include("view/template.php");
	}

	function imprimir()
	{
		header("Content-Type: text/html; charset=ISO-8859-1",true); 

		$codigo				= Get("codigo");
		$codigoInscricao	= Get("codigoInscricao");

		try 
		{
			try 
			{
				$factory = new WebService();
				$ret = $factory->GetBoletoInscricaoFutebol($codigo, $codigoInscricao);
			}
			catch (Exception $e) 
			{
				$mensagem = new Mensagem();
				$conteudo = $mensagem->Make('Servi&ccedil;o de Boleto ON-LINE n&atilde;o esta dispon&iacute;vel...'.$e);
				include("view/template.php");
				exit;
			}
			
			$result = $ret[0];
			$instrucao = Array();
			$demonstrativo = Array();
					
			// INSTRUCAO
			if (trim($result->InstrucaoRemessa11) != '') {
				$instrucao[count($instrucao)] = $result->InstrucaoRemessa11;
			}
			
			for ($i = 1; $i <= 25; $i++)
			{
				$method = 'InstrucaoTmp'.$i;
				if (trim($result->$method) != '') {
					$instrucao[count($instrucao)] = $result->$method;
				}
			}		

			// DEMONSTRATIVO
			if (trim($result->InstrucaoRemessa1) != '') {
				$demonstrativo[count($demonstrativo)] = $result->InstrucaoRemessa1;
			}
			if (trim($result->InstrucaoRemessa2) != '') {
				$demonstrativo[count($demonstrativo)] = $result->InstrucaoRemessa2;
			}
			if (trim($result->InstrucaoRemessa3) != '') {
				$demonstrativo[count($demonstrativo)] = $result->InstrucaoRemessa3;
			}
			if (trim($result->InstrucaoRemessa4) != '') {
				$demonstrativo[count($demonstrativo)] = $result->InstrucaoRemessa4;
			}
			if (trim($result->InstrucaoRemessa5) != '') {
				$demonstrativo[count($demonstrativo)] = $result->InstrucaoRemessa5;
			}
			
			if (trim($result->Instrucao1) != '') {
				$demonstrativo[count($demonstrativo)] = $result->Instrucao1;
			}
			if (trim($result->Instrucao2) != '') {
				$demonstrativo[count($demonstrativo)] = $result->Instrucao2;
			}
			if (trim($result->Instrucao3) != '') {
				$demonstrativo[count($demonstrativo)] = $result->Instrucao3;
			}
			if (trim($result->Instrucao4) != '') {
				$demonstrativo[count($demonstrativo)] = $result->Instrucao4;
			}
			
			if (trim($result->InstrucaoRemessa11) != '') {
				$demonstrativo[count($demonstrativo)] = $result->InstrucaoRemessa11;
			}
			
			for ($i = count($instrucao)+1; $i < 20; $i++){
				$instrucao[count($instrucao)] = '';
			}
			
			for ($i = count($demonstrativo); $i < 20; $i++){
				$demonstrativo[count($demonstrativo)] = '';
			}

			echo "    
				<style>

					@media print { 
						#noprint { display:none; } 
						body { background: #fff; }
					} 

				</style>
				
				<div id='noprint'>
					<br>
					<input type='button' class='btn btn-primary' name='imprimir' value='Imprimir' onclick='window.print();'>
					<br><br>
				</div>

				";
			
			if ($result->Banco == 748)
				include("boleto_sicredi.php");
			else if ($result->Banco == 1)
				include("boleto_bb.php");
			else if ($result->Banco == 104)
				include("boleto_cef.php");
			else if ($result->Banco == 237)
				include("boleto_bradesco.php");
			else if ($result->Banco == 341)
				include("boleto_itau.php");
			else if ($result->Banco == 347)
				include("boleto_real.php");
			else if ($result->Banco == 33) {
				include("boleto_santander_banespa.php");
			} else 
				throw new Exception('Banco n&atilde;o esta preparado para gerar boletos....');

			echo "
				<div id='noprint'>
					<br><br>
					<input type='button' class='btn btn-primary' name='imprimir' value='Imprimir' onclick='window.print();'>
					<br><br>
				</div>";

		} 
		catch (Exception $e) 
		{
			$mensagem = new Mensagem();
			$mensagem->redirect = "extrato.php?action=index";
			$mensagem->time = 5000;
			$conteudo = $mensagem->Make("Ocorreu um erro na gera&ccedil;&atilde;o do boleto.");
			include("view/template_error.php");
		}
	}

?>