<?php

	require_once('config.php');
	require_once('sysclub_functions/functions.php');
	require_once('sysclub_class/grid.php');
	require_once('sysclub_class/mensagem.php');
	require_once('sysclub_class/dateformat.php');
	require_once('sysclub_class/clientewebservice.php');

	$action = Get("action");

	switch ($action) 
	{
		case "salvar" :
			salvar();
			break;
		default : 
			index();
	}

	function index()
	{
		novo();
	}

	function novo()
	{
		global $CLUBE, $TITULO_SITE;

		include("view/form_solicitarsenha.php");	
	}

	function salvar()
	{
		global $CLUBE, $TITULO_SITE;

		$cota			= Get("cota");
		$datanascimento = Get("datanascimento"); 
		$login			= Get("login"); 
		$senha			= Get("senha"); 

		try
		{
			$factory = new WebService();
			$result = $factory->IdentificarSocio($cota, $datanascimento);
		}
		catch (Exception $e) 
		{
			$mensagem = new Mensagem();
			$conteudo = $mensagem->Make('<b>Servi&ccedil;o de Boleto ON-LINE n&atilde;o esta dispon&iacute;vel...</b>');
			include("view/template.php");
			exit;
		}

		if ($result != null && $result != -1)
		{
			try
			{
				$result = $factory->AlterarSenha($result, $login, $senha);
			}
			catch (Exception $e) 
			{
				$mensagem = new Mensagem();
				$conteudo = $mensagem->Make('<b>Servi&ccedil;o de Boleto ON-LINE n&atilde;o esta dispon&iacute;vel...</b>');
				include("view/template.php");
				exit;
			}

			if ($result == 1)
			{
				try
				{
					$result = $factory->Login($login, $senha);

					if ($result != null) 
					{
						setcookie ("LOGIN",	 $login);
						setcookie ("CODIGO", $result["Codigo"]);
						setcookie ("NOME",	 $result["Nome"]);

						$_SESSION["LOGIN"]	= $login;
						$_SESSION["CODIGO"] = $result["Codigo"];
						$_SESSION["NOME"]	= $result["Nome"];

						$mensagem = new Mensagem();
						$mensagem->time = 5000;
						$mensagem->redirect = "index.php";

						$conteudo = $mensagem->Make("<b>Senha foi salva com sucesso!</b>");

						include("view/template.php");
						exit;
					} 
					else 
					{
						setcookie("LOGIN", "", time()-42000);
						setcookie("CODIGO", "", time()-42000);
						setcookie("NOME", "", time()-42000);

						$_SESSION["LOGIN"]	= "";
						$_SESSION["CODIGO"] = "";
						$_SESSION["NOME"]	= "";

						session_destroy();

						$mensagem = new Mensagem();
						$mensagem->time = 10000;
						$mensagem->redirect = "solicitarsenha.php";
						
						$conteudo = $mensagem->Make("<b>Login pode estar sendo utilizado por outro usurio!</b><br><a href='solicitarsenha.php'>Clique aqui para tentar novamente.</a>");

						include("view/template.php");
						exit;
					}
				}
				catch (Exception $e) 
				{
					$mensagem = new Mensagem();
					$conteudo = $mensagem->Make('Servi&ccedil;o de Boleto ON-LINE n&atilde;o esta dispon&iacute;vel...');
					include("view/template.php");
					exit;
				}
			} 
			else 	
			{
				$mensagem = new Mensagem();
				$mensagem->time = 3000;
				$mensagem->redirect = "solicitarsenha.php";

				$conteudo = $mensagem->Make("<b>Login pode estar sendo utilizado por outro usurio!</b><br><a href='solicitarsenha.php'>Clique aqui para tentar novamente.</a>");

				include("view/template.php");
				exit;
			}
		} 
		else 
		{
			$mensagem = new Mensagem();
			$mensagem->time = 3000;
			$mensagem->redirect = "solicitarsenha.php";

			$conteudo = $mensagem->Make("<b>N&atilde;o foi possivel indentificar o s&oacute;cio.</b><br><a href='solicitarsenha.php'>Clique aqui para tentar novamente.</a>");

			include("view/template.php");
			exit;
		}
	}

?>