<?php

	class
  TBoletoCarteiraCEF_SICOB 
  private
    fCodigoBanco : String;
    fNumeroMoeda : String ;
    fIos : String ;
    fFixo : String ;
    fFatorVencimento : String;
    fTamanhoNossoNumeroComDV : Smallint;
    fValorStr : String;
    fNossoNumeroDVStr : String;
    fNossoNumeroSemDVStr : String;
    fCampoLivre : String;
    fBarraDvStr : String;
    fPermiteSemCPF: Integer;
    fSegmentoMensagem : Integer;
    function Modulo11NN(N : string; Peso : Smallint) : string;
  public
    procedure Prepare(); override;
    function FormatarCodigoBarras() : String; override ;
    function FormatarLinhaDigitavel(CodigoBarras : String) : String ; override ;
    function FormatarNossoNumeroDV: String;override ;
    function FormatarNossoNumeroImpresso: String; override ;
  end;

implementation

uses U_StringUtil;

{ TBoletoCarteiraCEF_SICOB }

Procedure TBoletoCarteiraCEF_SICOB.Prepare;
begin
  fPermiteSemCPF            := 0;
  fSegmentoMensagem         := 0;  
  fCodigoBanco              := '104';
  fNumeroMoeda              := '9';
  fTamanhoNossoNumeroComDV  := 11;
  fFixo     	              := '9';
  fIos	  		              := '0';
  fFatorVencimento          := RetornaFatorVencimento(DataVencimento);
  fValorStr                 := FormatarValor(ValorBoleto);
  fNossoNumeroDVStr         := FormatarNossoNumeroDV;
  fNossoNumeroSemDvStr      := Copy(fNossoNumeroDVStr,1,length(fNossoNumeroDVStr)-1);

  // 11 CS Cobrança Simples
  if Carteira = '11' then
  begin

  end;

  // 12 CR Cobrança Rápida - 9NNNNNNNNND
  if Carteira = '12' then
  begin

    // 9 - Identificador da carteira Rápida
    // NNNNNNNNN - Nosso número do Cliente
    // AAAA - CNPJ da Agência Cedente
    // YYY - Operação Código cedente
    // XXXXXXXX - Código cedente fornecido pela Agência

  end;
end;

function TBoletoCarteiraCEF_SICOB.FormatarNossoNumeroDV: String;
var
  NN : String;
begin
  // 11 CS Cobrança Simples
  // 12 CR Cobrança Rápida
  // SR Sem Registro

  NN := '';

  // 11 CS Cobrança Simples - NNNNNNNNNND
  if Carteira = '11' then
  begin
    NN := NN + ZeroEsquerdaInt(SequenciaNossoNumero, 10) ;
    NN := NN + Modulo11NN(NN,9);
  end;

  // 12 CR Cobrança Rápida - 9NNNNNNNNND
  if Carteira = '12' then
  begin
    NN := NN + '9' + ZeroEsquerdaInt(SequenciaNossoNumero, 9);
    NN := NN + Modulo11NN(NN,9);
  end;

  Result := NN ;
end;

function TBoletoCarteiraCEF_SICOB.FormatarNossoNumeroImpresso: String;
var
  NN, DV : String;
begin
  NN := FormatarNossoNumeroDV ;
  DV := copy(NN, Length(NN), 1);
  NN := copy(NN, 1, Length(NN)-1);
  Result := NN +'-'+ DV ;
end;

function TBoletoCarteiraCEF_SICOB.FormatarCodigoBarras: String;
var
  BarraSemDvTmp : String ;
begin
  BarraSemDvTmp :=  fCodigoBanco +      // 01 – 03 3   9 (3)   Identificação do banco
                    fNumeroMoeda +      // 04 – 04 1   9       Código da moeda (9 – real)
                    '' +                // 05 – 05 1   9       Dígito Verificador Geral do Código de Barras
                    fFatorVencimento +  // 06 – 09 4   9       Fator de Vencimento
                    fValorStr +         // 10 – 19 10  9 (8)   V99 Valor do Documento
                    fCampoLivre;        // 20 – 44 25  9 (25)  Campo Livre

  fBarraDvStr := DigitoCodigoBarras(BarraSemDvTmp);

  Result := '';
  Result := Copy(BarraSemDvTmp,1,4) + fBarraDvStr + Copy(BarraSemDvTmp, 5, 39);
  
  CheckCodigoBarras(Result);
end;

function TBoletoCarteiraCEF_SICOB.FormatarLinhaDigitavel(CodigoBarras : String): String;
var
  Campo1,
  Campo2,
  Campo3,
  Campo4,
  Campo5 : String;
begin
  // Campo 1
  // Posição 01 a 04 e posição 20 a 24   09
  // Dígito verificador Módulo 10        01

  Campo1 := '';
  Campo1 := Campo1 + Copy(CodigoBarras, 1, 4);
  Campo1 := Campo1 + Copy(CodigoBarras, 20, 5);
  Campo1 := Campo1 + Modulo10(Campo1);

  // Campo 2
  // Posição 25 a 34                     10
  // Dígito verificador Módulo 10        01
  Campo2 := '';
  Campo2 := Campo2 + Copy(CodigoBarras, 25, 10);
  Campo2 := Campo2 + Modulo10(Campo2);

  // Campo 3
  // Posição 35 a 44                     10
  // Dígito verificador Módulo 10        01
  Campo3 := '';
  Campo3 := Campo3 + Copy(CodigoBarras, 35, 10);
  Campo3 := Campo3 + Modulo10(Campo3);


  // Campo 4
  // Posição 05 (DV Geral)               01
  Campo4 := Copy(CodigoBarras, 5, 1);

  // Campo 5
  // Posição 06 a 09 (Fator de Vencimento) 04
  // Posição 10 a 19 (Valor do Título)     10
  Campo5 := '';
  Campo5 := Campo5 + Copy(CodigoBarras, 6, 4);
  Campo5 := Campo5 + Copy(CodigoBarras, 10, 10);

  Result := Campo1 + Campo2 + Campo3 + Campo4 + Campo5 ;

  CheckLinhaDigitavel(Result);
end;

function TBoletoCarteiraCEF_SICOB.Modulo11NN(N : string; Peso : Smallint) : string;
var
  Somatorio, m, f : Integer;
begin
  m := 2;
  Somatorio := 0;
  for f := Length(N) downto 1 do
  begin
    Somatorio := Somatorio + (StrToInt(N[f]) * m);
    inc(m);
    if m = Peso + 1 then
      m := 2;
  end;

  m := (Somatorio mod 11);
  m := 11 - m ;
  if m > 9 then
    m := 0 ;

  Result := IntToStr(m);
end;


end.