<?php

	require_once('stringutil.php'); 
	require_once('cob_carteira_base.php');
	
	class TBoletoCarteiraItau_103_109_112_173 
	{		
		var $util;
		var $base;
		
		var $CodigoBanco = "";
		var $NumeroMoeda = "";
		var $Ios = "";
		var $Fixo = "";
		var $FatorVencimento = "";
		var $TamanhoNossoNumeroComDV = 0 ;
		var $ValorStr = "";
		var $NossoNumeroDVStr = "";
		var $NossoNumeroSemDVStr = "";
		var $CampoLivre = "";
		var $BarraDvStr = "";
		var $PermiteSemCPF = 0 ;
		var $SegmentoMensagem = 0 ;
		
		var $ValorBoleto = 0 ;
		var $DataVencimento = null;
		var $Agencia;
		var $Carteira;
		var $Conta;
		var $ContaDV;
		var $SequenciaNossoNumero;
		
		function __construct() 
		{
			$this->util = new StringUtil();
			$this->base = new TBoletoCarteiraBase();
		}

		function Prepare()
		{			
			$this->PermiteSemCPF           	= 0;
			$this->SegmentoMensagem        	= 0;  
			$this->CodigoBanco             	= '341';
			$this->NumeroMoeda             	= '9';
			$this->TamanhoNossoNumeroComDV 	= 9;    	// Quantidade de dígitos Nosso Número(com DV)
			$this->Fixo     	            	= '9';   	// Numero fixo para a posição 05-05
			$this->Ios	  		            	= '0';   	// IOS - somente para Seguradoras (Se 7% informar 7, limitado 9%) // Demais clientes usar 0 (zero)
			$this->FatorVencimento         	= $this->base->RetornaFatorVencimento($this->DataVencimento);
			$this->ValorStr                	= $this->base->FormatarValor($this->ValorBoleto);
			$this->NossoNumeroDVStr        	= $this->FormatarNossoNumeroDV();
			$this->NossoNumeroSemDVStr     	= substr($this->NossoNumeroDVStr, 0, strlen($this->NossoNumeroDVStr)-1);
			$this->CampoLivre              	= '';
		}

		function FormatarNossoNumeroDV()
		{
			$NN  = $this->util->ZeroEsquerda($this->SequenciaNossoNumero, $this->TamanhoNossoNumeroComDV-1);
			$NN .= $this->base->Modulo10($this->util->ZeroEsquerda($this->Agencia,4));
			
			$tmp  = $this->util->ZeroEsquerda($this->Conta,5);
			$tmp .= $this->util->ZeroEsquerda($this->Carteira,3);
			
			return $tmp .$NN ;
		}

		function FormatarNossoNumeroImpresso()
		{
			$NN = $this->FormatarNossoNumeroDV();
			$DV = substr($NN, strlen($NN)-1, 1);
			$NN = substr($NN, 0, strlen($NN)-1);
			return $this->Carteira .' / '. $NN .'-'. $DV ;
		}
		
		function FormatarCodigoBarras()
		{
			$BarraSemDvTmp = $this->CodigoBanco 
							 .$this->NumeroMoeda 
							 .$this->FatorVencimento 
							 .$this->ValorStr 
							 .$this->util->ZeroEsquerda($this->Carteira,3) 
							 .$this->NossoNumeroDVStr 
							 .$this->util->ZeroEsquerda($this->Agencia,4) 
							 .$this->util->ZeroEsquerda($this->Conta,5) 
							 .$this->ContaDV 
							 .'000';

			$BarraDvStr = $this->base->DigitoCodigoBarras($BarraSemDvTmp);

			$Result = substr($BarraSemDvTmp,0,4) .$BarraDvStr .substr($BarraSemDvTmp, 4, 39);
			$this->base->CheckCodigoBarras($Result);
			return $Result;
		}

		function FormatarLinhaDigitavel($CodigoBarras)
		{
			$Campo1 = $this->CodigoBanco .$this->NumeroMoeda .$this->util->ZeroEsquerda($this->Carteira,3) .substr($this->NossoNumeroDVStr,0,2);
			$Campo1 = $Campo1 .$this->base->Modulo10($Campo1);
			
			$Campo2 = substr($this->NossoNumeroDVStr,2,7) .substr($this->util->ZeroEsquerda($this->Agencia,4),0,3);
			$Campo2 = $Campo2 .$this->base->Modulo10(Campo2);
			
			$Campo3 = substr($this->util->ZeroEsquerda($this->Agencia,4),3,1) .$this->util->ZeroEsquerda($this->Conta,5) .$this->ContaDV .'000';
			$Campo3 = $Campo3 .$this->base->Modulo10($Campo3);
			
			$Campo4 = $this->BarraDvStr;
			$Campo5 = $this->FatorVencimento .$this->ValorStr;
			
			$Result = $Campo1 .$Campo2 .$Campo3 .$Campo4 .$Campo5;
			$this->base->CheckLinhaDigitavel($Result);
			return $Result;
		}
	}

?>