<?php
	
	require_once('../config.php');
	require_once('conexao.php');
	require_once('stringutil.php'); 
	require_once('cob_cobrador.php');
	require_once('cob_boleto.php');
	
	require_once('cob_carteira_base.php');
	require_once('cob_carteira_bradesco.php');
	require_once('cob_carteira_itau.php');
	require_once('cob_carteira_sicredi.php'); 
	require_once('cob_carteira_santander.php'); 
	
	class TBCobranca 
	{
		var $oConexao;
		var $StringUtil;
		var $ListBoleto = Array();
		
		var $CalcularJuro 		= false ;
		var $Preparado 			= false ;
		var $Impresso  			= false ;
		var $Salvo     			= false ;
		var $TipoVencimento		= 2;
		var $Agrupado			= false ;
		var $ImprimirComJuros 	= false;
		var $ImprimirDataVencimento = 0;
		
		var $Cobrador;
		
		// consts
		var $BOLETO_ESPECIEDOC           = 1;
		var $BOLETO_EMISSAO              = 2;
		var $BOLETO_IMPRESSAO            = 3;
		var $BOLETO_CARTEIRA             = 4;
		var $BOLETO_TIPOCOBRANCA         = 5;
		var $BOLETO_TIPODESCONTO         = 6;
		var $BOLETO_TIPOJURO             = 7;
		var $BOLETO_TIPOMULTA            = 8;
		var $BOLETO_INSTRUCAO_COBRANCA1  = 9;
		var $BOLETO_INSTRUCAO_COBRANCA2  = 10;
		var $BOLETO_ENTREGA              = 11;
		
		var $SYSCLUB_2004               = 1 ;
		var $SYSCLUB_NIKKEI             = 2 ;
		var $SYSCLUB_VERACRUZ           = 4 ;
		var $SYSCLUB_COM                = 5 ;
		var $SYSCLUB_COMERCIALARAPONGAS = 6 ;
		var $SYSCLUB_PIRATININGA        = 7 ;
		var $SYSCLUB_ODY				= 8 ;
		var $SYSCLUB_ITAMIRIM			= 9 ;
		var $SYSCLUB_HCCP				= 10;
		var $SYSCLUB_TCSJC				= 11;
		var $SYSCLUB_CCM				= 12;
		var $SYSCLUB_YCP				= 13;
		var $SYSCLUB_AFMM				= 14;
		var $SYSCLUB_COOPERCOTIA		= 15;
		var $SYSCLUB_FISHING 			= 16;
		var $SYSCLUB_ACEMA				= 17;
		var $SYSCLUB_AGUAAZUL			= 18;
		var $SYSCLUB_HELVETIA			= 19;
		var $SYSCLUB_CIC				= 20;
		var $SYSCLUB_ADPM				= 21;
		var $SYSCLUB_CCA				= 22;
		var $SYSCLUB_JARAGUA			= 23;
		var $SYSCLUB_GUARANI			= 24;
		var $SYSCLUB_ICL				= 25;
		var $SYSCLUB_MARINGAGOLFCLUB	= 26;
		var $SYSCLUB_OASIS				= 27;
		var $SYSCLUB_SERMEP				= 28;
		var $SYSCLUB_CIANORTECLUBE		= 29;
		var $SYSCLUB_NOSSOLAR           = 30;
		var $SYSCLUB_PENHA              = 31;
		var $SYSCLUB_AABBSANTOS         = 32;
		var $SYSCLUB_CAIUACOUNTRY       = 33;  
		
		var $INSTRUCAO_COBRADOR = 1;
		var $INSTRUCAO_LANCTOS  = 2;
		var $INSTRUCAO_MULTA    = 3;
		var $INSTRUCAO_JUROS    = 4;
		var $INSTRUCAO_DESCONTO = 5;
		var $INSTRUCAO_LAYOUT   = 6;
	
		var $SysClubCliente = -1;
		
		function __construct() 
		{
			global $GLOBALS, $CLIENTE;
			
			$this->Cobrado = new TCobrador();
			$this->oConexao = new Conexao();
			$this->StringUtil = new StringUtil();
			
			$this->SysClubCliente = $CLIENTE;		
		}
		
		function ClearListBoleto()
		{
			$this->ListBoleto = Array();
		}
		
		function getCodigosBancos($codigoBanco, $tipo, $codigo)
		{
			$sql = " SELECT * FROM TB_BOLETOS_CODIGOSBANCO WHERE CD_BANCO = $codigoBanco AND CD_TIPO = $tipo and CODIGO = '$codigo'  ";

			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
			
			return $arr;
		}
		
		function getEspecieDocumentoSigla($codigoBanco, $codigoEspecieDoc)
		{
			$sql = "SELECT SIGLA FROM TB_BOLETOS_CODIGOSBANCO WHERE CD_BANCO = $codigoBanco AND CD_TIPO = 1 AND CODIGO = '$codigoEspecieDoc' ";
			
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
			
		  	if (count($arr) >= 1) {
				return $arr[0]['SIGLA'] ;
			}
			return '';
		}

		function getIdentificador($codigoBanco, $tipoDado, $codigo)
		{
			$sql = "SELECT IDENTIFICADOR FROM TB_BOLETOS_CODIGOSBANCO WHERE CD_BANCO = $codigoBanco AND CD_TIPO = $tipoDado AND CODIGO = '$codigo' ";
			
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
			
		  	if (count($arr) >= 1) 
				return $arr[0]['IDENTIFICADOR'] ;
			return '';
		}
		
		function SelectPorCodigo($codigoBoleto)
		{
			$sql = "";
			$sql .= " SELECT                                           	";
			$sql .= "   BD.*,                                          	";
			$sql .= "   (SELECT FIRST 1 BCB.SIGLA FROM TB_BOLETOS_CODIGOSBANCO BCB WHERE BCB.CD_BANCO = BD.CD_BANCO AND BCB.CD_TIPO = 1 AND BD.ESPECIEDOC = BCB.CODIGO) AS ESPECIEDOCSIGLA, ";
			$sql .= "   TD.NR_COTA, TD.DV_COTA,                        	";
			$sql .= "  (TD.NR_COTA || '-' || TD.DV_COTA) AS TITULO   	";
			$sql .= " FROM                                             	";
			$sql .= "   TB_BOLETOS_DEBAUT BD                           	";
			$sql .= "   LEFT JOIN TB_TITULAR_DEPENDENTE TD ON (TD.CODIGO = BD.CODIGO) ";
			$sql .= " WHERE                                            	";
			$sql .= "   BD.CD_BOLETOS_DEBAUT = $codigoBoleto AND  		";
			$sql .= "   BD.ST_BOLETO IS NULL                           	";
			$sql .= " ORDER BY                                         	";
			$sql .= "   BD.NOSSO_NUMERO                                	";

			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
			
			return $arr;
		}

		function LoadPorCodigoBoleto($codigoBoleto)
		{
			$data = $this->SelectPorCodigo($codigoBoleto);
			
			$boleto = $this->AddBoleto();
			$boleto = $this->CopiarBoleto($boleto, $data);
			$boleto = $this->CopiarInstrucoes($boleto);
			$boleto = $this->CopiarDadosBancarioSacado($boleto);
		}
		
		function CopiarBoleto($boleto, $data)
		{
			$boleto->CodigoBoleto             = $data[0]['CD_BOLETOS_DEBAUT'];
			$boleto->CodigoLote               = $data[0]['CD_BOLETOS_LOTE'];
			$boleto->CodigoCobrador           = $data[0]['CD_COBRADOR'];  

			$boleto->Banco                    = $data[0]['CD_BANCO'];
			$boleto->Agencia                  = $data[0]['NR_AGENCIA'];
			$boleto->AgenciaDv                = $data[0]['NR_AGENCIA_DV'];
			$boleto->Conta                    = $data[0]['NR_CC'];
			$boleto->ContaDv                  = $data[0]['NR_CC_DV'];
			$boleto->AgenciaContaDv           = $data[0]['NR_AGENCIA_CC_DV'];

			$boleto->LinhaDigitavel           = $data[0]['LINHA_DIGITAVEL'];
			$boleto->CodigoBarras             = $data[0]['CODIGO_BARRAS'];

			$boleto->NossoNumero              = $data[0]['NOSSO_NUMERO'];
			$boleto->NossoNumeroSemDV         = $data[0]['NOSSO_NUMERO_SEM_DV'];
			$boleto->NossoNumeroFormatado     = $data[0]['NOSSO_NUMERO_FORMATO'];

			if ($data[0]['NOSSO_NUMERO_SEQUENCIA'] != '')
					$boleto->SequenciaNossoNumero = $data[0]['NOSSO_NUMERO_SEQUENCIA'];

			$boleto->LocalPagamento           = $data[0]['LOCALPAGAMENTO1'];
			$boleto->NumeroDocumento          = $data[0]['NUMERODOC'];

			$boleto->DataEmissao              = $data[0]['DT_EMISSAO'];
			$boleto->DataVencimento           = $data[0]['DT_VENCIMENTO'];
			$boleto->DataVencimentoU          = $data[0]['DT_VENCIMENTOU'];
			$boleto->DataDocumento            = $data[0]['DT_DOCUMENTO'];
			$boleto->DataProcessamento        = $data[0]['DT_PROCESSAMENTO'];
			$boleto->DataMulta                = $data[0]['DT_MULTA'];
			$boleto->DataLimiteDesconto1      = $data[0]['DT_LIMITE_DES_1'];
			$boleto->DataLimiteDesconto2      = $data[0]['DT_LIMITE_DES_2'];
			$boleto->DataLimiteDesconto3      = $data[0]['DT_LIMITE_DES_3'];

			$boleto->VlrOuPercMultaAtraso     = $data[0]['MULTA'];
			$boleto->VlrOuPercJurosDiaAtraso  = $data[0]['JUROS'];
			$boleto->VlrOuPercDesconto        = $data[0]['DESCONTO'];
			$boleto->ValorBoleto              = $data[0]['VALORTOTAL'];
			$boleto->ValorIof                 = $data[0]['VR_IOF'];
			$boleto->ValorAbatimento          = $data[0]['VR_ABATIMENTO'];
			$boleto->ValorTarifa              = $data[0]['VR_TARIFA'];
			$boleto->ValorPrincipal           = $data[0]['VALORPRINCIPAL'];

			$boleto->Quantidade               = $data[0]['QUANTIDADEMOEDA'];
			$boleto->ValorMoeda               = $data[0]['VALORMOEDA'];
			$boleto->Carteira                 = $data[0]['CARTEIRA'];
			$boleto->Convenio                 = $data[0]['CONVENIO'];
			$boleto->Posto                    = $data[0]['POSTO'];
			$boleto->TipoCobranca             = $data[0]['TIPOCOBRANCA'];
			$boleto->Aceite                   = $data[0]['ACEITE'];
			$boleto->Especie                  = $data[0]['ESPECIE'];
			$boleto->EspecieDoc               = $data[0]['ESPECIEDOC'];
			$boleto->EspecieDocSigla          = $data[0]['ESPECIEDOCSIGLA'];

			$boleto->TipoImpressao            = $data[0]['TIPOIMPRESSAO'];
			$boleto->EmissaoBoleto            = $data[0]['EMISSAOBOLETO'];
			$boleto->EntregaBoleto            = $data[0]['ENTREGABOLETO'];
			$boleto->InstrucaoCobranca1       = $data[0]['INSTRUCAOCOBRANCA1'];
			$boleto->InstrucaoCobranca2       = $data[0]['INSTRUCAOCOBRANCA2'];
			$boleto->DiasProtesto             = $data[0]['DIASPROTESTO'];
			$boleto->DiasBaixa                = $data[0]['DIASBAIXA'];

			// CEDENTE
			$boleto->Cedente_CpfCnpj          = $data[0]['CNPJCEDENTE'];
			$boleto->Cedente_Nome             = $data[0]['NOMECEDENTE'];
			$boleto->Cedente_Endereco         = $data[0]['ENDERECOCEDENTE'];
			$boleto->Cedente_Bairro           = $data[0]['BAIRROCEDENTE'];
			$boleto->Cedente_Cidade           = $data[0]['CIDADECEDENTE'];
			$boleto->Cedente_Uf               = $data[0]['UFCEDENTE'];
			$boleto->Cedente_Cep              = $data[0]['CEPCEDENTE'];
			$boleto->Cedente_Telefone         = $data[0]['FONECEDENTE'];
			$boleto->Cedente_Email            = $data[0]['EMAILCEDENTE'];

			// SACADO
			$boleto->Sacado_CodigoSysClub     = $data[0]['CODIGO'];
			$boleto->Sacado_CpfCnpj           = $data[0]['CNPJSACADO'];
			$boleto->Sacado_Nome              = $data[0]['NOMESACADO'];
			$boleto->Sacado_Endereco          = $data[0]['ENDERECOSACADO'];
			$boleto->Sacado_Bairro            = $data[0]['BAIRROSACADO'];
			$boleto->Sacado_Cidade            = $data[0]['CIDADESACADO'];
			$boleto->Sacado_Uf                = $data[0]['UFSACADO'];
			$boleto->Sacado_Cep               = $data[0]['CEPSACADO'];
			$boleto->Sacado_Telefone          = $data[0]['FONESACADO'];
			$boleto->Sacado_Email             = $data[0]['EMAILSACADO'];
			$boleto->Sacado_Titulo            = $data[0]['TITULO'] ;
			$boleto->Sacado_NumeroCota        = $data[0]['NR_COTA'] ;
			$boleto->Sacado_DigitoCota        = $data[0]['DV_COTA'] ;

			// SACADOR/AVALISTA
			$boleto->SacadorAvalista_Nome     = $data[0]['NOMESACADORAVALISTA'];
			$boleto->SacadorAvalista_CpfCnpj  = $data[0]['CNPJSACADORAVALISTA'];
			$boleto->SacadorAvalista_Endereco = $data[0]['ENDERECOSACADORAVALISTA'];
			$boleto->SacadorAvalista_Bairro   = $data[0]['BAIRROSACADORAVALISTA'];
			$boleto->SacadorAvalista_Cidade   = $data[0]['CIDADESACADORAVALISTA'];
			$boleto->SacadorAvalista_Uf       = $data[0]['UFSACADORAVALISTA'];
			$boleto->SacadorAvalista_Cep      = $data[0]['CEPSACADORAVALISTA'];

			$boleto->Instrucao1               = $data[0]['INSTRUCAO1'];
			$boleto->Instrucao2               = $data[0]['INSTRUCAO2'];
			$boleto->Instrucao3               = $data[0]['INSTRUCAO3'];
			$boleto->Instrucao4               = $data[0]['INSTRUCAO4'];
			$boleto->Instrucao5               = $data[0]['INSTRUCAO5'];
			$boleto->Instrucao6               = $data[0]['INSTRUCAO6'];

			$boleto->InstrucaoRemessa1        = $data[0]['INSTRUCAOREM1'];
			$boleto->InstrucaoRemessa2        = $data[0]['INSTRUCAOREM2'];
			$boleto->InstrucaoRemessa3        = $data[0]['INSTRUCAOREM3'];
			$boleto->InstrucaoRemessa4        = $data[0]['INSTRUCAOREM4'];
			$boleto->InstrucaoRemessa5        = $data[0]['INSTRUCAOREM5'];
			$boleto->InstrucaoRemessa6        = $data[0]['INSTRUCAOREM6'];
			$boleto->InstrucaoRemessa7        = $data[0]['INSTRUCAOREM7'];
			$boleto->InstrucaoRemessa8        = $data[0]['INSTRUCAOREM8'];
			$boleto->InstrucaoRemessa9        = $data[0]['INSTRUCAOREM9'];
			$boleto->InstrucaoRemessa10       = $data[0]['INSTRUCAOREM10'];
			$boleto->InstrucaoRemessa11       = $data[0]['INSTRUCAOREM11'];
			$boleto->NumeroParcela            = $data[0]['NR_PARCELA'];

			$boleto->Impresso                 = $data[0]['IMPRESSO'] == 1;
			
			return $boleto;
		}

		function CopiarDadosBancarioSacado($boleto)
		{
			$codigo = $boleto->Sacado_CodigoSysClub;

			$sql = " SELECT NR_AGENCIA, NR_AGENCIA_DV, NR_CC, NR_CC_DV FROM TB_TITULAR_DEPENDENTE WHERE CODIGO = $codigo ";
			
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
			
			foreach($arr as $row)
			{			
			    $boleto->Sacado_Agencia           	= $row['NR_AGENCIA'] ;
				$boleto->Sacado_Agencia_DV        	= $row['NR_AGENCIA_DV'] ;
				$boleto->Sacado_ContaCorrente     	= $row['NR_CC'] ;
				$boleto->Sacado_ContaCorrente_DV	= $row['NR_CC_DV'] ;
			}
			
			return $boleto;
		}
		
		function CopiarInstrucoes($boleto)
		{
			$codigoBoleto = $boleto->CodigoBoleto;
			$sql = "SELECT * FROM TB_BOLETOS_DEBAUT_INSTR WHERE CD_BOLETOS_DEBAUT = $codigoBoleto AND TIPO IN(2,3,4) ORDER BY ORDEM ";
			
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
			
			foreach($arr as $row)
			{					
				$i = $row['ORDEM'];
					
				if ((is_int($i)) || (is_float($i)))
				{
					$method1 = 'InstrucaoTmp'.$i;
					$method2 = 'InstrucaoTipoTmp'.$i;
					
					$boleto->$method1	= $row['INSTRUCAO'];
					$boleto->$method2  	= $row['TIPO'];
				}
			}
			
			return $boleto;
		}
		
		function CarregarDadosCobrador($codigoCobrador)
		{			
			$sql = "";	
			$sql .= " SELECT 													";
			$sql .= "   *														";
			$sql .= " FROM				                                        ";
			$sql .= "   TB_COBRADOR C	                                        ";
			$sql .= "   INNER JOIN TB_CONTACOR CC ON (CC.CD_CONTA = C.CD_CONTA)	";
			$sql .= " WHERE														";
			$sql .= "   C.CD_COBRADOR = $codigoCobrador 						";
			
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
			
			$this->Cobrador = new TCobrador();
			$this->Cobrador->Banco                    	= $arr[0]['CD_BANCO'];			
			$this->Cobrador->Agencia                  	= $arr[0]['AGENCIA'];
			$this->Cobrador->AgenciaDv                	= $arr[0]['AGENCIA_DV'];
			$this->Cobrador->Conta                    	= $arr[0]['CONTACORRENTE'];
			$this->Cobrador->ContaDv                  	= $arr[0]['CONTACORRENTE_DV'];
			$this->Cobrador->SequenciaNossoNumero		= $arr[0]['SQ_BOLETO'];
			$this->Cobrador->SequenciaNossoNumeroInc  	= $arr[0]['SQ_BOLETO'];

			$this->Cobrador->TipoCobrador             	= $arr[0]['CD_COBRADOR_TIPO'] ;
			$this->Cobrador->CodigoConta              	= $arr[0]['CD_CONTA'];
			$this->Cobrador->CodigoCobrador           	= $arr[0]['CD_COBRADOR'];
			$this->Cobrador->Carteira                 	= $arr[0]['CARTEIRA'];
			$this->Cobrador->Convenio                 	= $arr[0]['CONVENIO'];
			$this->Cobrador->Posto                    	= $arr[0]['POSTO'];
			$this->Cobrador->CodigoFlash              	= $arr[0]['CODIGOFLASH'];
			$this->Cobrador->TipoCobranca             	= $arr[0]['TIPOCOBRANCA'];
			$this->Cobrador->Aceite					  	= 'N';
			
			if ($arr[0]['ACEITE'] == 1)
				$this->Cobrador->Aceite = 'S';

			$this->Cobrador->Especie                  	= $arr[0]['ESPECIE'];
			$this->Cobrador->EspecieDoc               	= $arr[0]['ESPECIEDOC'];

			$this->Cobrador->TipoImpressao            	= $arr[0]['TIPOIMPRESSAO'];
			$this->Cobrador->EmissaoBoleto            	= $arr[0]['EMISSAOBOLETO'];
			$this->Cobrador->EntregaBoleto            	= $arr[0]['ENTREGABOLETO'];
			$this->Cobrador->InstrucaoCobranca1       	= $arr[0]['INSTRUCAOCOBRANCA1'];
			$this->Cobrador->InstrucaoCobranca2       	= $arr[0]['INSTRUCAOCOBRANCA2'];
			$this->Cobrador->DiasProtesto             	= $arr[0]['DIASPROTESTO'];
			$this->Cobrador->DiasBaixa                	= $arr[0]['DIASBAIXA'];
			$this->Cobrador->TipoMulta                	= $arr[0]['TIPOMULTA'];
			$this->Cobrador->TipoJuros                	= $arr[0]['TIPOJUROS'];
			$this->Cobrador->TipoDesconto             	= $arr[0]['TIPODESCONTO'];
			$this->Cobrador->LocalPagamento           	= $arr[0]['LOCALPAGAMENTO1'];

			$this->Cobrador->DiasMultaAposVenc        	= $arr[0]['DIAS_MULTA'];

			$this->Cobrador->DiasDescontoAnt1         	= $arr[0]['DIAS_ANT_1'];
			$this->Cobrador->DiasDescontoAnt2         	= $arr[0]['DIAS_ANT_2'];
			$this->Cobrador->DiasDescontoAnt3         	= $arr[0]['DIAS_ANT_3'];

			$this->Cobrador->PercDescontoAnt1         	= $arr[0]['PERC_ANT_1'];
			$this->Cobrador->PercDescontoAnt2         	= $arr[0]['PERC_ANT_2'];
			$this->Cobrador->PercDescontoAnt3         	= $arr[0]['PERC_ANT_3'];

			$this->Cobrador->Cedente_Codigo           	= $arr[0]['CODIGOCEDENTE'];
			$this->Cobrador->Cedente_Nome             	= $arr[0]['NOMECEDENTE'];
			$this->Cobrador->Cedente_CpfCnpj          	= $arr[0]['CNPJCEDENTE'];
			$this->Cobrador->Cedente_Cep              	= $arr[0]['CEPCEDENTE'];
			$this->Cobrador->Cedente_Endereco         	= $arr[0]['ENDERECOCEDENTE'];
			$this->Cobrador->Cedente_Bairro           	= $arr[0]['BAIRROCEDENTE'];
			$this->Cobrador->Cedente_Cidade           	= $arr[0]['CIDADECEDENTE'];
			$this->Cobrador->Cedente_Uf               	= $arr[0]['UFCEDENTE'];

			$this->Cobrador->SacadorAvalista_Nome     	= $arr[0]['NOMESACADORAVALISTA'];
			$this->Cobrador->SacadorAvalista_CpfCnpj  	= $arr[0]['CNPJSACADORAVALISTA'];
			$this->Cobrador->SacadorAvalista_Cep      	= $arr[0]['CEPSACADORAVALISTA'];
			$this->Cobrador->SacadorAvalista_Endereco 	= $arr[0]['ENDERECOSACADORAVALISTA'];
			$this->Cobrador->SacadorAvalista_Bairro   	= $arr[0]['BAIRROSACADORAVALISTA'];
			$this->Cobrador->SacadorAvalista_Cidade   	= $arr[0]['CIDADESACADORAVALISTA'];
			$this->Cobrador->SacadorAvalista_Uf       	= $arr[0]['UFSACADORAVALISTA'];

			$this->Cobrador->DescricaoAbreviado       	= $arr[0]['ABREVIADO'];
			$this->Cobrador->DescricaoConta           	= $arr[0]['USAR_NM_CONTA'];

			$this->Cobrador->DiretorioEnvio           	= $arr[0]['NM_PASTA_ENVIO'];
			$this->Cobrador->DiretorioRetorno         	= $arr[0]['NM_PASTA_RETORNO'];

			$this->Cobrador->InstrucaoCobrador1       	= $arr[0]['INSTRUCAO1'];
			$this->Cobrador->InstrucaoCobrador2       	= $arr[0]['INSTRUCAO2'];
			$this->Cobrador->InstrucaoCobrador3       	= $arr[0]['INSTRUCAO3'];
			$this->Cobrador->InstrucaoCobrador4       	= $arr[0]['INSTRUCAO4'];
			
			$Data = $this->getCodigosBancos($this->Cobrador->Banco, $this->BOLETO_INSTRUCAO_COBRANCA1, $this->Cobrador->InstrucaoCobranca1);
			if (count($Data) >= 1) {
				if ($this->Cobrador->InstrucaoCobrador5 == '') {
					$this->Cobrador->InstrucaoCobrador5 = $Data[0]['DESCRICAO'];
				}
			}

			$Data = $this->getCodigosBancos($this->Cobrador->Banco, $this->BOLETO_INSTRUCAO_COBRANCA2, $this->Cobrador->InstrucaoCobranca2);
			if (count($Data) >= 1) {
				if ($this->Cobrador->InstrucaoCobrador6 == '') {
					$this->Cobrador->InstrucaoCobrador6 = $Data[0]['DESCRICAO'];
				}
			}

			$this->Cobrador->EspecieDocSigla = $this->getEspecieDocumentoSigla($this->Cobrador->Banco, $arr[0]['ESPECIEDOC']);
			$this->Cobrador->MultaPV         = $this->getIdentificador($this->Cobrador->Banco, $this->BOLETO_TIPOMULTA, $arr[0]['TIPOMULTA']);
			$this->Cobrador->JurosPV         = $this->getIdentificador($this->Cobrador->Banco, $this->BOLETO_TIPOJURO, $arr[0]['TIPOJUROS']);
			$this->Cobrador->DescontoPV      = $this->getIdentificador($this->Cobrador->Banco, $this->BOLETO_TIPODESCONTO, $arr[0]['TIPODESCONTO']);
		}
		
		function ProximoSequenciaNossoNumero()
		{
			$this->Cobrador->SequenciaNossoNumeroInc ++;
			return $this->Cobrador->SequenciaNossoNumeroInc;
		}
		
		function MontarInstrucaoBoleto($boleto)
		{					
			$list = Array();
			
			$sInstrucaoMulta = '';
			$sInstrucaoJuros = '';
			$sInstrucaoDesconto1 = '';
			$sInstrucaoDesconto2 = '';
			$sInstrucaoDesconto3 = '';
			
			$tmpContas = '';
			$tmpCurr = 0.00;
			$SeqMensagem = 0;

			$descTamanho       = 10;
			$valTamanho        = 8;
			$segmentoMensagem  = 40;

			// descTamanho (10) + valTamanho (8) = 18 + espaço 2 = 20 segmentoMensagem 40 OU 80
			// descTamanho (15) + valTamanho (8) = 23 + espaço 2 = 25 segmentoMensagem 50

			if ($this->SysClubCliente == $this->SYSCLUB_COOPERCOTIA) {
				$segmentoMensagem  = 50 ;
				$descTamanho       = 35 ;
			} else if ($this->Cobrador->Banco == 33) {
				$segmentoMensagem  = 50 ;
				$descTamanho       = 15 ;	
			} else if (($this->Cobrador->Banco == 104) || ($this->Cobrador->Banco == 237)) {
				$segmentoMensagem = 80 ;
				if ($this->Cobrador->DescricaoAbreviado == 1) { 
					$descTamanho = 10 ;
				} else {
					$descTamanho = 16 ;
				}
			} else if ($this->Cobrador->Banco == 748) { 
				$segmentoMensagem = 80 ;
				if ($this->Cobrador->DescricaoAbreviado == 1) { 
					$descTamanho = 10 ;
				} else { 
					$descTamanho = 30 ;
				}
			}
			
			$SeqMensagem = 0;
			$lancamentos = $boleto->getListLancamentoFinanceiro();
	
			if ($this->Cobrador->DescricaoAbreviado > 0)
			{
				if ($this->Cobrador->DescricaoAbreviado == 1)
				{
					$sql = "";
					$sql .= " SELECT                                              	";
					$sql .= "   DESCRICAO,                                        	";
					$sql .= "   SUM(TOTAL) AS TOTAL                               	";
					$sql .= " FROM                                                	";
					$sql .= " (                                                   	";
					$sql .= " SELECT                                              	";
					$sql .= "   C.NM_ABREVIACAO AS DESCRICAO,                     	";
					$sql .= "  (L.VALOR) AS TOTAL 									";
					$sql .= " FROM                                                	";
					$sql .= "   TB_LANCAMENTOS L                                  	";
					$sql .= "   LEFT JOIN TB_CONTA C ON (C.CD_CONTA = L.CD_CONTA) 	";
					$sql .= " WHERE                                               	";
					$sql .= "   L.NR_LANCAMENTO IN (". $lancamentos .") AND    		";
					$sql .= "   L.ST_LANCAMENTO != 'X'                          	";
					$sql .= " ) AS TESTE                                          	";
					$sql .= " GROUP BY                                            	";
					$sql .= "   DESCRICAO                                         	";
					$sql .= " ORDER BY 2 DESC                                     	";
					
				} 
				else if ($this->Cobrador->DescricaoAbreviado == 2) 
				{
					$sql = "";
					$sql .= " SELECT                                              ";
					$sql .= "   DESCRICAO,                                        ";
					$sql .= "   SUM(TOTAL) AS TOTAL                               ";
					$sql .= " FROM                                                ";
					$sql .= " (                                                   ";
					$sql .= " SELECT                                              ";
					$sql .= "   C.NM_CONTA AS DESCRICAO,                          ";
					$sql .= "  (L.VALOR) as TOTAL                                 ";
					$sql .= " FROM                                                ";
					$sql .= "   TB_LANCAMENTOS L                                  ";
					$sql .= "   LEFT JOIN TB_CONTA C ON (C.CD_CONTA = L.CD_CONTA) ";
					$sql .= " WHERE                                               ";
					$sql .= "   L.NR_LANCAMENTO IN (". $lancamentos .") AND   	  ";
					$sql .= "   L.ST_LANCAMENTO != 'X'                            ";
					$sql .= " ) AS TESTE                                          ";
					$sql .= " GROUP BY                                            ";
					$sql .= "   DESCRICAO                                         ";
					$sql .= " ORDER BY 2 DESC                                     ";
				}
				
				$tmpContas = '';

				$this->oConexao->Conecta();
				$arr = $this->oConexao->toArray($sql);
				$this->oConexao->Desconecta();

				foreach($arr as $row)
				{
					$SeqMensagem = $SeqMensagem + 1; 
					if ($this->SysClubCliente == $this->SYSCLUB_COOPERCOTIA) {
						$tmpContas .= $this->StringUtil->ZeroEsquerda($SeqMensagem, 2) .' - ';
					}
										
					$des = $this->StringUtil->CopyEspacoDireita($row['DESCRICAO'], 0, $descTamanho);				
					$val = $this->StringUtil->CopyEspacoEsquerda($this->StringUtil->FormatCurr('#,##0.00', $row['TOTAL']), 0, $valTamanho);
	
					$tmpContas .= $des .' ';
					$tmpContas .= $val .' ';
					
					if (strlen($tmpContas) + ($descTamanho + $valTamanho + 2) > $segmentoMensagem)
					{
						$list[count($list)] = $tmpContas;
						$tmpContas = '';
					}
				}

				if ($tmpContas != '')
				{
					$list[count($list)] = $tmpContas;
					$tmpContas = '';
				}
				
				// encargos
				if (($this->CalcularJuro) && ($boleto->ValorBoleto != $boleto->ValorPrincipal))
				{
					$tmpContas .= $this->StringUtil->CopyEspacoDireita('MULTAS+JUROS', 0, $descTamanho) .' ';
					$tmpContas .= $this->StringUtil->CopyEspacoEsquerda($this->StringUtil->FormatCurr('#,##0.00', $boleto->ValorBoleto - $boleto->ValorPrincipal), 0, $valTamanho) .' ';
					$list[count($list)] = $tmpContas;
					$tmpContas = '';
				}
			}
			// fim
			
			// ICL
			if ($this->SysClubCliente == $this->SYSCLUB_ICL) 
			{				
				if ($boleto->VlrOuPercDesconto != 0)
				{
					$sub = substr($boleto->Sacado_Titulo, strlen($boleto->Sacado_Titulo)-2, 2);
										
					if (($sub != 'PE') && ($boleto->DataVencimento >= $this->StringUtil->StrToDateTime('01/10/2014'))) 
					{
						if ($boleto->PercDescontoAnt1 != 0) 
						{			
							$tmpContas  = 'ATE '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto1) .', COBRAR R$ '.  $this->StringUtil->FormatCurr('#,##0.00', $boleto->ValorBoleto - $boleto->PercDescontoAnt1) .'                              ';
							$tmpContas  = substr($tmpContas,0,48);							
							$sInstrucaoDesconto1 = $tmpContas;
							
							$tmpContas	= 'DE '. $this->StringUtil->FormatDateTime('d/m/Y', $this->StringUtil->IncDay($boleto->DataLimiteDesconto1, 1)) .' A '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataVencimento) .', COBRAR R$ '.  $this->StringUtil->FormatCurr('#,##0.00', $boleto->ValorBoleto-$boleto->PercDescontoAnt2) .'                              ';
							$tmpContas  = substr($tmpContas,0,48);
							$sInstrucaoDesconto2 = $tmpContas;
						}
					}
					else
					{
						if ($boleto->ValorBoleto == $boleto->ValorPrincipal) 
						{							
							if ($sub == 'PE') 
								$tmpContas = 'ATE '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataVencimento)  .' CONCEDER DESCONTO DE R$ '.  $this->StringUtil->FormatCurr('#,##0.00',$boleto->VlrOuPercDesconto);
							else
								$tmpContas = 'ATE '. $this->StringUtil->FormatDateTime('d/m/Y', $this->StringUtil->IncDay($boleto->DataVencimento, -10)) .' CONCEDER DESCONTO DE R$ '.  $this->StringUtil->FormatCurr('#,##0.00',$boleto->VlrOuPercDesconto);
							
							$tmpContas	= $tmpContas .'                              ';
							$tmpContas  = substr($tmpContas,0,48);
							$sInstrucaoDesconto1 	= $tmpContas;
						}
					}
				}
			}
			// FIM ICL
			
			// PENHA
			else if ($this->SysClubCliente == $this->SYSCLUB_PENHA) 
			{
				if ($boleto->VlrOuPercDesconto != 0)
				{
					$sub = substr($boleto->Sacado_Titulo, strlen($boleto->Sacado_Titulo)-2, 2);
					
					if (($sub != 'PE') && ($boleto->DataVencimento >= $this->StringUtil->StrToDateTime('01/10/2014')))
					{
						if ($boleto->PercDescontoAnt1 != 0) 
						{
							$tmpContas    = 'ATE '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto1) .', COBRAR R$ '.  $this->StringUtil->FormatCurr('#,##0.00',$boleto->ValorBoleto-$boleto->PercDescontoAnt1) .'                              ';
							$tmpContas    = substr($tmpContas,0,48);
							$sInstrucaoDesconto1 = $tmpContas;

							$tmpContas    = 'DE '. $this->StringUtil->FormatDateTime('d/m/Y', $this->StringUtil->IncDay($boleto->DataLimiteDesconto1, 1)) .' A '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto2) .', COBRAR R$ '.  $this->StringUtil->FormatCurr('#,##0.00',$boleto->ValorBoleto-$boleto->PercDescontoAnt2) .'                              ';
							$tmpContas    = substr($tmpContas,0,48);
							$sInstrucaoDesconto2 = $tmpContas;
						}
					}
					else
					{
						if ($sub == 'PE')
							$tmpContas = 'ATE '.  $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataVencimento) .' CONCEDER DESCONTO DE R$ '.  $this->StringUtil->FormatCurr('#,##0.00',$boleto->VlrOuPercDesconto);
						else
							$tmpContas = 'ATE '.  $this->StringUtil->FormatDateTime('d/m/Y', $this->StringUtil->IncDay($boleto->DataVencimento, -10))  .' CONCEDER DESCONTO DE R$ ' . $this->StringUtil->FormatCurr('#,##0.00',$boleto->VlrOuPercDesconto);
					  
						$tmpContas	= $tmpContas .'                              ';
						$tmpContas  = substr($tmpContas,0,48);
						$sInstrucaoDesconto1 = $tmpContas;
				   }
				}
			} // FIM PENHA
			
			// TODOS
			else if ($boleto->VlrOuPercDesconto > 0)
			{
				if (($boleto->DataLimiteDesconto1 == 0) &&
				    ($boleto->DataLimiteDesconto2 == 0) &&
					($boleto->DataLimiteDesconto3 == 0))
				{
						$boleto->DataLimiteDesconto1 = $boleto->DataVencimento;
						$boleto->PercDescontoAnt1    = $boleto->VlrOuPercDesconto;

					if ($this->Cobrador->DescontoPV == 'V')
					{
						if (($this->SysClubCliente == $this->SYSCLUB_AGUAAZUL) or
						    ($this->SysClubCliente == $this->SYSCLUB_CCA) or
							($this->SysClubCliente == $this->SYSCLUB_CIANORTECLUBE) or
							($this->SysClubCliente == $this->SYSCLUB_CIC)  OR
							($this->SysClubCliente == $this->SYSCLUB_COMERCIALARAPONGAS) or
							($this->SysClubCliente == $this->SYSCLUB_HCCP))
						{
							$tmpCurr = round($boleto->VlrOuPercDesconto, 2);
						} 
						else 
						{
							 $tmpCurr = round($boleto->ValorBoleto * ($boleto->VlrOuPercDesconto / 100), 2);
						}
						 
								$boleto->VlrOuPercDesconto = $tmpCurr;
						  $sInstrucaoDesconto1 = 'CONCEDER DESCONTO DE R$ '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr).' SE PAGO ATÉ '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto1);
					} 
					else if ($this->Cobrador->DescontoPV == 'P') 
					{
						$tmpCurr = round($boleto->VlrOuPercDesconto, 2);
						$sInstrucaoDesconto1 = 'CONCEDER DESCONTO DE '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr).' % SE PAGO ATÉ '.$this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto1);
					}
				}
				else
				{
					if ($boleto->DataLimiteDesconto1 > 0) 
					{
						if ($this->Cobrador->DescontoPV == 'V')
						{
							if (($this->SysClubCliente == $this->SYSCLUB_AGUAAZUL) or
							    ($this->SysClubCliente == $this->SYSCLUB_CCA) or
							    ($this->SysClubCliente == $this->SYSCLUB_CIANORTECLUBE) or
							    ($this->SysClubCliente == $this->SYSCLUB_CIC)  OR
							    ($this->SysClubCliente == $this->SYSCLUB_COMERCIALARAPONGAS) or
							    ($this->SysClubCliente == $this->SYSCLUB_HCCP)) 
							{
							   $tmpCurr = round($boleto->PercDescontoAnt1, 2);
							}
							else 
							{
							   $tmpCurr = $boleto->ValorBoleto * ($boleto->PercDescontoAnt1 / 100);
							}
								   
							$tmpCurr = round($tmpCurr, 2);
							$sInstrucaoDesconto1 = 'ATÉ '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto1) .', CONCEDER DESCONTO DE R$ '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr);
								$boleto->PercDescontoAnt1    = $tmpCurr;
								$boleto->VlrOuPercDesconto   = $tmpCurr;
						}
						else if ($this->Cobrador->DescontoPV == 'P')
						{
							$tmpCurr = $boleto->PercDescontoAnt1;
							$tmpCurr = round($tmpCurr, 2);
							$sInstrucaoDesconto1 = 'ATÉ '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto1) .', CONCEDER DESCONTO DE '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr).' %';
						}
					}

					if ($boleto->DataLimiteDesconto2 > 0) 
					{
						if ($this->Cobrador->DescontoPV == 'V')
						{
							if (($this->SysClubCliente == $this->SYSCLUB_AGUAAZUL) ||
							    ($this->SysClubCliente == $this->SYSCLUB_CCA) ||
							    ($this->SysClubCliente == $this->SYSCLUB_CIAN||TECLUBE) ||
							    ($this->SysClubCliente == $this->SYSCLUB_CIC)  ||
							    ($this->SysClubCliente == $this->SYSCLUB_COMERCIALARAPONGAS) ||
							    ($this->SysClubCliente == $this->SYSCLUB_HCCP)) 
							{
							   $tmpCurr = round($boleto->PercDescontoAnt2, 2);
							}
							else 
							{
							   $tmpCurr = $boleto->ValorBoleto * ($boleto->PercDescontoAnt2 / 100);
							}
							   
								$boleto->PercDescontoAnt2 = $tmpCurr;
							$tmpCurr = round($tmpCurr, 2);
							$sInstrucaoDesconto2 = 'ATÉ '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto2) .', CONCEDER DESCONTO DE R$ '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr);
						}
						else if ($this->Cobrador->DescontoPV == 'P')
						{
							$tmpCurr = $boleto->PercDescontoAnt2;
							$tmpCurr = round($tmpCurr, 2);
							$sInstrucaoDesconto2 = 'ATÉ '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto2) .', CONCEDER DESCONTO DE '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr).' %';
						}
					}

					if ($boleto->DataLimiteDesconto3 > 0) 
					{
						if ($this->Cobrador->DescontoPV == 'V') 
						{
							if (($this->SysClubCliente == $this->SYSCLUB_AGUAAZUL) ||
							    ($this->SysClubCliente == $this->SYSCLUB_CCA) ||
							    ($this->SysClubCliente == $this->SYSCLUB_CIAN||TECLUBE) ||
							    ($this->SysClubCliente == $this->SYSCLUB_CIC) ||
							    ($this->SysClubCliente == $this->SYSCLUB_COMERCIALARAPONGAS) ||
							    ($this->SysClubCliente == $this->SYSCLUB_HCCP)) 
							{
							   $tmpCurr = round($boleto->PercDescontoAnt3, 2);
							}
							else 
							{
							   $tmpCurr = $boleto->ValorBoleto * ($boleto->PercDescontoAnt3 / 100);
							}
								   
								$boleto->PercDescontoAnt3 = $tmpCurr;
							$tmpCurr = round($tmpCurr, 2);
							$sInstrucaoDesconto3 = 'ATÉ '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto3) .', CONCEDER DESCONTO DE R$ '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr);
						}
						else if ($this->Cobrador->DescontoPV == 'P') 
						{
							$tmpCurr = $boleto->PercDescontoAnt3;
							$tmpCurr = round($tmpCurr, 2);
							$sInstrucaoDesconto3 = 'ATÉ '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataLimiteDesconto3) .', CONCEDER DESCONTO DE '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr).' %';
						}
					 }
				}
			}
			// FIM TODOS
			
			if ($boleto->VlrOuPercMultaAtraso > 0)
			{							
				$tmpCurr = 0;
				if ($this->Cobrador->MultaPV == 'V')
				{					
					if ($this->SysClubCliente == $this->SYSCLUB_OASIS)
					{
						$tmpCurr = $boleto->VlrOuPercMultaAtraso;
						$tmpCurr = round($tmpCurr, 2);
					}
					else
					{
						$tmpCurr = $boleto->ValorBoleto * ($boleto->VlrOuPercMultaAtraso / 100);
						$tmpCurr = round($tmpCurr, 2);
					}
						
					$sInstrucaoMulta = 'APOS '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataVencimento) .', MULTA DE R$ '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr);
				}
				else 
				{					
					if ($this->Cobrador->MultaPV == 'P') 
					{						
						$tmpCurr = $boleto->VlrOuPercMultaAtraso;
						$tmpCurr = round($tmpCurr, 2);
						$sInstrucaoMulta = 'APOS '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataVencimento) .', MULTA DE '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr) .' %';
					}
				}				
			}
			
			if ($boleto->VlrOuPercJurosDiaAtraso > 0)
			{
				$tmpCurr = 0;
				if ($this->Cobrador->JurosPV == 'V') 
				{
					if (($this->SysClubCliente == $this->SYSCLUB_2004) ||
						($this->SysClubCliente == $this->SYSCLUB_ODY))
					{
						$tmpCurr = $boleto->VlrOuPercJurosDiaAtraso ;
					}
					else if (($this->SysClubCliente == $this->SYSCLUB_FISHING) ||
							 ($this->SysClubCliente == $this->SYSCLUB_CCM)) 
					{
						$tmpCurr = $boleto->ValorBoleto * ($boleto->VlrOuPercJurosDiaAtraso / 100);
					}
					else 
					{
						$tmpCurr = $boleto->ValorBoleto * ($boleto->VlrOuPercJurosDiaAtraso / 30 / 100);
					}
                
					$tmpCurr = round($tmpCurr, 2);
					$sInstrucaoJuros = 'APOS '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataVencimento) .', MORA DIARIA DE R$ '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr);
				}
				else if ($this->Cobrador->JurosPV == 'P')
				{
					$tmpCurr = $boleto->VlrOuPercJurosDiaAtraso;
					$tmpCurr = round($tmpCurr, 2);
					$sInstrucaoJuros = 'APOS '. $this->StringUtil->FormatDateTime('d/m/Y', $boleto->DataVencimento) .', JUROS DE '. $this->StringUtil->FormatCurr('#,##0.00', $tmpCurr).' %';
				}
				
					$boleto->VlrOuPercJurosDiaAtraso = round($tmpCurr, 2);
			}

			
			while (count($list) < 11){
				$list[count($list)] = '';
			}

			// Instruções Fixas Cadastro Cobrador
			$boleto->Instrucao1 = $this->Cobrador->InstrucaoCobrador1;
			$boleto->Instrucao2 = $this->Cobrador->InstrucaoCobrador2;
			$boleto->Instrucao3 = $this->Cobrador->InstrucaoCobrador3;
			$boleto->Instrucao4 = $this->Cobrador->InstrucaoCobrador4;

			// Resumo dos Lançamentos
			$boleto->Instrucao5 = $list[0];
			$boleto->Instrucao6 = $list[1];
			$boleto->Instrucao7 = $list[2];
			$boleto->Instrucao8 = $list[3];
			$boleto->Instrucao9 = $list[4];
			$boleto->Instrucao10= $list[5];

			// Instruções LayOut Banco
			$boleto->InstrucaoRemessa1 = $sInstrucaoMulta;
			$boleto->InstrucaoRemessa2 = $sInstrucaoJuros;
			$boleto->InstrucaoRemessa3 = $sInstrucaoDesconto1;
			$boleto->InstrucaoRemessa4 = $sInstrucaoDesconto2;
			$boleto->InstrucaoRemessa5 = $sInstrucaoDesconto3;
			$boleto->InstrucaoRemessa6 = $this->Cobrador->InstrucaoCobrador5;
			$boleto->InstrucaoRemessa7 = $this->Cobrador->InstrucaoCobrador6;

			//  Nova Implementação *******************
			$boleto->InstrucaoTmp1      = $this->Cobrador->InstrucaoCobrador1;
			$boleto->InstrucaoTipoTmp1  = $this->INSTRUCAO_COBRADOR;
			$boleto->InstrucaoTmp2      = $this->Cobrador->InstrucaoCobrador2;
			$boleto->InstrucaoTipoTmp2  = $this->INSTRUCAO_COBRADOR;
			$boleto->InstrucaoTmp3      = $this->Cobrador->InstrucaoCobrador3;
			$boleto->InstrucaoTipoTmp3  = $this->INSTRUCAO_COBRADOR;
			$boleto->InstrucaoTmp4      = $this->Cobrador->InstrucaoCobrador4;
			$boleto->InstrucaoTipoTmp4  = $this->INSTRUCAO_COBRADOR;
			$boleto->InstrucaoTmp5      = $list[0];
			$boleto->InstrucaoTipoTmp5  = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp6      = $list[1];
			$boleto->InstrucaoTipoTmp6  = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp7      = $list[2];
			$boleto->InstrucaoTipoTmp7  = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp8      = $list[3];
			$boleto->InstrucaoTipoTmp8  = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp9      = $list[4];
			$boleto->InstrucaoTipoTmp9  = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp10     = $list[5];
			$boleto->InstrucaoTipoTmp10 = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp11     = $list[6];
			$boleto->InstrucaoTipoTmp11 = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp12     = $list[7];
			$boleto->InstrucaoTipoTmp12 = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp13     = $list[8];
			$boleto->InstrucaoTipoTmp13 = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp14     = $list[9];
			$boleto->InstrucaoTipoTmp14 = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp15     = $list[10];
			$boleto->InstrucaoTipoTmp15 = $this->INSTRUCAO_LANCTOS;
			$boleto->InstrucaoTmp16     = $sInstrucaoMulta;
			$boleto->InstrucaoTipoTmp16 = $this->INSTRUCAO_MULTA;
			$boleto->InstrucaoTmp17     = $sInstrucaoJuros;
			$boleto->InstrucaoTipoTmp17 = $this->INSTRUCAO_JUROS;
			$boleto->InstrucaoTmp18     = $sInstrucaoDesconto1;
			$boleto->InstrucaoTipoTmp18 = $this->INSTRUCAO_DESCONTO;
			$boleto->InstrucaoTmp19     = $sInstrucaoDesconto2;
			$boleto->InstrucaoTipoTmp19 = $this->INSTRUCAO_DESCONTO;
			$boleto->InstrucaoTmp20     = $sInstrucaoDesconto3;
			$boleto->InstrucaoTipoTmp20 = $this->INSTRUCAO_DESCONTO;
			$boleto->InstrucaoTmp21     = $this->Cobrador->InstrucaoCobrador5;
			$boleto->InstrucaoTipoTmp21 = $this->INSTRUCAO_LAYOUT;
			$boleto->InstrucaoTmp22     = $this->Cobrador->InstrucaoCobrador6;
			$boleto->InstrucaoTipoTmp22 = $this->INSTRUCAO_LAYOUT;
			$boleto->InstrucaoTmp23     = '';
			$boleto->InstrucaoTipoTmp23 = 0;
			$boleto->InstrucaoTmp24     = '';
			$boleto->InstrucaoTipoTmp24 = 0;
			$boleto->InstrucaoTmp25     = '';
			$boleto->InstrucaoTipoTmp25 = 0;
		}
		// fim MontarInstrucaoBoleto
		
		function Prepare()
		{			
			if ($this->SysClubCliente <= -1)
				  throw new Exception('Cliente nao foi identificado');
			
			// DATA DO VENCIMENTO
			
			if ($this->ImprimirDataVencimento == 0)
			{				
				$tempDate = date('Y-m-d');
				$this->ImprimirDataVencimento = $tempDate;
			}
			
			foreach($this->ListBoleto as $boleto)
			{			
				$tempDate = date('Y-m-d');
			
				// Vencimento Hoje
				if ($this->TipoVencimento == 0) {
						$boleto->DataVencimento = $tempDate;
				}
			  
				// Vencimento Amanhã
				if ($this->TipoVencimento == 1) {
						$boleto->DataVencimento = $this->StringUtil->IncDay($tempDate, 1);
				}
				
				// Vencimento na Data do Vencimento do ÚLTIMO lançamento selecionado
				if ($this->TipoVencimento == 2) {
						$boleto->DataVencimento = $this->GetMaiorVencimento($boleto->getListLancamentoFinanceiro()) ;
				}        
				
				// Informar a Data do Vencimento
				if ($this->TipoVencimento == 3) {
						$boleto->DataVencimento = $this->ImprimirDataVencimento ;
				}   

				if (!$this->ImprimirComJuros) {
					$boleto->ValorBoleto = $this->GetValorPagarReceber($boleto->getListLancamentoFinanceiro(),$boleto->DataVencimento);
				} else {
					$boleto->ValorBoleto = $this->AtualizaValor($boleto->getListLancamentoFinanceiro(), $tempDate);
				}				
			}
			
			if ($boleto->DataVencimento < $this->ImprimirDataVencimento) {
					$boleto->DataVencimento = $this->ImprimirDataVencimento;
			}			
			
			// FIM DATA DO VENCIMENTO
			
			// SELECIONANDO A CARTEIRA
			$Carteira = null;
			
			if ($this->Cobrador->Banco == 33)
			{	
				$Carteira = new TBoletoCarteiraSantander();			
			}
			
			if ($this->Cobrador->Banco == 237)
			{	
				if (($this->Cobrador->Carteira == '06') || 
				    ($this->Cobrador->Carteira == '09') || 
					($this->Cobrador->Carteira == '16') || 
					($this->Cobrador->Carteira == '19'))    
				{
					$Carteira = new TBoletoCarteiraBradesco_06_09_16_19();	
				}						
			}

			if ($this->Cobrador->Banco == 341)
			{
				if (($this->Cobrador->Carteira == '103') || 
				    ($this->Cobrador->Carteira == '109') || 
					($this->Cobrador->Carteira == '112') || 
					($this->Cobrador->Carteira == '173'))    
				{
					$Carteira = new TBoletoCarteiraItau_103_109_112_173();	
				}
			}	
			
			if ($this->Cobrador->Banco == 748)
			{  
				$Carteira = new TBoletoCarteiraSicredi();	
			}	
			
			if ($Carteira == null)
				throw new Exception('Cobrador selecionado a carteira não esta preparada');
		
			// FIM DA CARTEIRA
		
			$nValor20 = 0.00;
			$nValor30 = 0.00;
			$lancamentos = "";
		  
			foreach($this->ListBoleto as $boleto)
			{
					$boleto->BoletoCarteiraBase = $Carteira;
					$boleto->Prepare();
				
					$boleto->DataMulta            = 0;
					$boleto->DataLimiteDesconto1  = 0;
					$boleto->DataLimiteDesconto2  = 0;
					$boleto->DataLimiteDesconto3  = 0;
					$boleto->PercDescontoAnt1     = 0;
					$boleto->PercDescontoAnt2     = 0;
					$boleto->PercDescontoAnt3     = 0;
				
				if ($this->Cobrador->DiasMultaAposVenc > 0){
						$boleto->DataMulta = $this->StringUtil->IncDay($boleto->DataVencimento, $this->Cobrador->DiasMultaAposVenc);
				}

				if ($this->SysClubCliente == $this->SYSCLUB_ICL)
				{
					$lancamentos = $boleto->getListLancamentoFinanceiro();

					if ($boleto->VlrOuPercDesconto > 0)
					{
						$sub = substr($boleto->Sacado_Titulo, strlen($boleto->Sacado_Titulo)-2, 2);
						
						if (($sub != 'PE') && ($boleto->DataVencimento >= $this->StringUtil->StrToDateTime('01/10/2014')))
						{
							$nValor20 = 0.0;
							$nValor30 = 0.0;

							$sql = " SELECT NR_LANCAMENTO FROM TB_PAGAR_RECEBER_NV WHERE NR_LANCAMENTO IN (". $lancamentos .") ";

							$this->oConexao->Conecta();
							$arr = $this->oConexao->toArray($sql);
							$this->oConexao->Desconecta();

							foreach($arr as $row)
							{
								$dateSplit = date_parse($boleto->DataVencimento);
								$Year 	= $dateSplit['year'];
								$Month 	= $dateSplit['month'];
								$Day 	= $dateSplit['day'];								

								$pDtBase = mktime(0, 0, 0, $Month, 19, $Year);
								$pDtBase = date('Y-m-d', $pDtBase);
								$sql = " Select * FROM PR_ATUALIZA_LANCAMENTO(". $row['NR_LANCAMENTO'] .", '$pDtBase') ";								
								$this->oConexao->Conecta();
								$arrSub = $this->oConexao->toArray($sql);
								$this->oConexao->Desconecta();
								$nValor20 = $nValor20 + $arrSub[0]['VR_ATUALIZADO'];
								
								
								$pDtBase = mktime(0, 0, 0, $Month, 25, $Year);
								$pDtBase = date('Y-m-d', $pDtBase);
								$sql = " Select * FROM PR_ATUALIZA_LANCAMENTO(". $row['NR_LANCAMENTO'] .", '$pDtBase') ";
								$this->oConexao->Conecta();
								$arrSub = $this->oConexao->toArray($sql);
								$this->oConexao->Desconecta();
								$nValor30 = $nValor30 + $arrSub[0]['VR_ATUALIZADO'];
							}

								$boleto->PercDescontoAnt1     = $boleto->ValorBoleto - $nValor20;
								$boleto->VlrOuPercDesconto    = $boleto->PercDescontoAnt1;
							
							if ($boleto->PercDescontoAnt1 != 0) 
							{
								$dateSplit = date_parse($boleto->DataVencimento);
								$Year = $dateSplit['year'];
								$Month = $dateSplit['month'];
								$Day = $dateSplit['day'];	
								
								$pDtBase = mktime(0, 0, 0, $Month, 20, $Year);
								$pDtBase = date('Y-m-d', $pDtBase);
								
									$boleto->DataLimiteDesconto1 = $pDtBase;
							}

								$boleto->PercDescontoAnt2 = $boleto->ValorBoleto - $nValor30;
							if ($boleto->PercDescontoAnt2 != 0) {
									$boleto->DataLimiteDesconto2  = $boleto->DataVencimento;
							}

							if (($boleto->PercDescontoAnt1 == 0) && ($boleto->PercDescontoAnt2 == 0)) {
									$boleto->VlrOuPercDesconto = 0;
							}
						}
						else
						{
							if ($boleto->VlrOuPercDesconto != 0) 
							{
								$sub = substr($boleto->Sacado_Titulo, strlen($boleto->Sacado_Titulo)-2, 2);
								
								if ($sub == 'PE') { 
										$boleto->DataLimiteDesconto1  = $boleto->DataVencimento;
								} else {
										$boleto->DataLimiteDesconto1  = $boleto->DataVencimento-10;
								}
								 
									$boleto->PercDescontoAnt1 = $boleto->VlrOuPercDesconto;
							}
						}
					}
				}
					
				else if (($this->SysClubCliente == $this->SYSCLUB_PENHA) && (substr($boleto->InstrucaoRemessa11, 0, 5) == 'ANUID'))
				{
					$dateSplit = date_parse($boleto->DataVencimento);
					$Year 	= $dateSplit['year'];
					$Month 	= $dateSplit['month'];
					$Day 	= $dateSplit['day'];
								
					$sql = ' Select * FROM TB_ANUIDADESPENHA where ano = $Year AND vl_semdesconto = '. $boleto->ValorBoleto .' ';

					$this->oConexao->Conecta();
					$arr = $this->oConexao->toArray($sql);
					$this->oConexao->Desconecta();
						
					foreach($arr as $row)
					{
							$boleto->PercDescontoAnt1     = $row['VL_DESCONTO1'];
							$boleto->DataLimiteDesconto1  = $row['DT_DESCONTO1'];
							$boleto->PercDescontoAnt2     = $row['VL_DESCONTO2'];
							$boleto->DataLimiteDesconto2  = $row['DT_DESCONTO2'];		
					}
				}
				else if (($this->Cobrador->DiasDescontoAnt1 > 0) || ($boleto->PercDescontoAnt1 > 0))
				{
						$boleto->DataLimiteDesconto1 = $this->StringUtil->IncDay($boleto->DataVencimento, $this->Cobrador->DiasDescontoAnt1 * -1);
						$boleto->PercDescontoAnt1    = $this->Cobrador->PercDescontoAnt1;
				}

				if (($this->Cobrador->DiasDescontoAnt2 > 0) && ($boleto->PercDescontoAnt2 > 0))
				{
						$boleto->DataLimiteDesconto2 = $this->StringUtil->IncDay($boleto->DataVencimento, $this->Cobrador->DiasDescontoAnt2 * -1);
						$boleto->PercDescontoAnt2    = $this->Cobrador->PercDescontoAnt2;
				}

				if (($this->Cobrador->DiasDescontoAnt3 > 0) && ($boleto->PercDescontoAnt3 > 0))
				{
						$boleto->DataLimiteDesconto3 = $this->StringUtil->IncDay($boleto->DataVencimento, $this->Cobrador->DiasDescontoAnt3 * -1);
						$boleto->PercDescontoAnt3    = $this->Cobrador->PercDescontoAnt3;
				}

					$boleto->ValorAbatimento = 0;
					$boleto->ValorIof        = 0;
					$boleto->ValorTarifa     = 0;
								
				if (($boleto->DataLimiteDesconto1 != 0) && ($boleto->DataLimiteDesconto2 == 0)) {
						$boleto->DataLimiteDesconto2 = $boleto->DataVencimento;
				} else if (($boleto->DataLimiteDesconto2 != 0) && ($boleto->DataLimiteDesconto3 == 0)) {
						$boleto->DataLimiteDesconto3 = $boleto->DataVencimento;
				}
				
				$this->MontarInstrucaoBoleto($boleto);
			}
		}
	
		function AddBoleto()
		{
			$Result = new TBoleto();
			$Result->NossoNumero		= "";
			$Result->CodigoLote			= 0 ;
			$Result->CodigoCobrador     = $this->Cobrador->CodigoCobrador ;
			$Result->Banco              = $this->Cobrador->Banco;
			$Result->Agencia            = $this->Cobrador->Agencia;
			$Result->AgenciaDv          = $this->Cobrador->AgenciaDv;
			$Result->Conta              = $this->Cobrador->Conta;
			$Result->ContaDv            = $this->Cobrador->ContaDv;
			$Result->Carteira           = $this->Cobrador->Carteira;
			$Result->Convenio           = $this->Cobrador->Convenio;
			$Result->Posto              = $this->Cobrador->Posto;
			$Result->TipoCobranca       = $this->Cobrador->TipoCobranca;
			$Result->TipoRemessa        = $this->Cobrador->TipoRemessa;
			$Result->TipoImpressao      = $this->Cobrador->TipoImpressao;
			$Result->EmissaoBoleto      = $this->Cobrador->EmissaoBoleto;
			$Result->EntregaBoleto      = $this->Cobrador->EntregaBoleto;
			$Result->TipoMulta          = $this->Cobrador->TipoMulta;
			$Result->TipoDesconto       = $this->Cobrador->TipoDesconto;
			$Result->TipoJuros          = $this->Cobrador->TipoJuros;
			$Result->Aceite         	= $this->Cobrador->Aceite;
			$Result->Especie            = $this->Cobrador->Especie;
			$Result->EspecieDoc         = $this->Cobrador->EspecieDoc;
			$Result->EspecieDocSigla    = $this->Cobrador->EspecieDocSigla;
			$Result->InstrucaoCobranca1 = $this->Cobrador->InstrucaoCobranca1;
			$Result->InstrucaoCobranca2 = $this->Cobrador->InstrucaoCobranca2;
			$Result->DiasProtesto       = $this->Cobrador->DiasProtesto;
			$Result->DiasBaixa          = $this->Cobrador->DiasBaixa;
			$Result->LocalPagamento     = $this->Cobrador->LocalPagamento;

			// A verificar 10/11/2016
			$Result->Instrucao1         		= $this->Cobrador->Instrucao1;
			$Result->Instrucao2         		= $this->Cobrador->Instrucao2;
			$Result->Instrucao3         		= $this->Cobrador->Instrucao3;
			$Result->Instrucao4         		= $this->Cobrador->Instrucao4;
			$Result->Instrucao5         		= $this->Cobrador->Instrucao5;
			$Result->Instrucao6         		= $this->Cobrador->Instrucao6;

			$Result->Cedente_Codigo             = $this->Cobrador->Cedente_Codigo;
			$Result->Cedente_Nome               = $this->Cobrador->Cedente_Nome;
			$Result->Cedente_CpfCnpj            = $this->Cobrador->Cedente_CpfCnpj;
			$Result->Cedente_Cep                = $this->Cobrador->Cedente_Cep;
			$Result->Cedente_Endereco           = $this->Cobrador->Cedente_Endereco;
			$Result->Cedente_Bairro             = $this->Cobrador->Cedente_Bairro;
			$Result->Cedente_Cidade             = $this->Cobrador->Cedente_Cidade;
			$Result->Cedente_Uf                 = $this->Cobrador->Cedente_Uf;
			$Result->Cedente_Telefone           = $this->Cobrador->Cedente_Telefone;
			$Result->Cedente_Email              = $this->Cobrador->Cedente_Email;

			$Result->SacadorAvalista_Nome       = $this->Cobrador->SacadorAvalista_Nome;
			$Result->SacadorAvalista_CpfCnpj    = $this->Cobrador->SacadorAvalista_CpfCnpj;
			$Result->SacadorAvalista_Cep        = $this->Cobrador->SacadorAvalista_Cep;
			$Result->SacadorAvalista_Endereco   = $this->Cobrador->SacadorAvalista_Endereco;
			$Result->SacadorAvalista_Bairro     = $this->Cobrador->SacadorAvalista_Bairro;
			$Result->SacadorAvalista_Cidade     = $this->Cobrador->SacadorAvalista_Cidade;
			$Result->SacadorAvalista_Uf         = $this->Cobrador->SacadorAvalista_Uf;

			$Result->DataDocumento      = date('Y-m-d');
			$Result->DataProcessamento  = date('Y-m-d');
			$Result->DataEmissao        = date('Y-m-d');

			$i = count($this->ListBoleto);
			$this->ListBoleto[$i] = $Result;
			
			return $Result;
		}
		
		function UpdateSequenciaBoleto($codigoCobrador, $SequenciaAtual, $SequenciaNova)
		{
			$afetados = 0 ;
			
			$sql = "";
			$sql = " SELECT * FROM TB_COBRADOR  WHERE CD_COBRADOR = $codigoCobrador ";
			
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
					
			if (($arr[0]["SQ_BOLETOINI"] <= $SequenciaNova) &&
			    ($arr[0]["SQ_BOLETOFIM"] >= $SequenciaNova))
			{
				$sql = "";
				$sql .= "	UPDATE TB_COBRADOR                  ";
				$sql .= "	SET SQ_BOLETO = $SequenciaNova      ";
				$sql .= "	WHERE CD_COBRADOR = $codigoCobrador ";	

				$this->oConexao->Conecta();
				$res = $this->oConexao->Execute($sql);
				$afetados = $this->oConexao->RegistrosAfetados();
				$this->oConexao->Desconecta();				
			}	
			return $afetados == 1;
		}

		function BoletoLote_GetGenerator()
		{
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray(" SELECT GEN_ID(GEN_TB_BOLETOS_LOTE_ID,1) as CODIGO FROM RDB\$DATABASE ");
			$this->oConexao->Desconecta();
			return $arr[0]["CODIGO"];
		}
		
		function BoletoDebaut_GetGenerator()
		{
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray(" SELECT GEN_ID(GEN_TB_BOLETOS_DEBAUT_ID,1) as CODIGO FROM RDB\$DATABASE ");
			$this->oConexao->Desconecta();
			return $arr[0]["CODIGO"];
		}

		function BoletoDebautDisc_GetGenerator()
		{
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray(" SELECT GEN_ID(GEN_TB_BOLETOS_DEBAUT_DISC_ID,1) as CODIGO FROM RDB\$DATABASE ");
			$this->oConexao->Desconecta();
			return $arr[0]["CODIGO"];
		}
		
		function BoletoInstrucao_GetGenerator()
		{
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray(" SELECT GEN_ID(GEN_TB_BOLETOS_DEBAUT_INSTR_ID,1) as CODIGO FROM RDB\$DATABASE ");
			$this->oConexao->Desconecta();
			return $arr[0]["CODIGO"];
		}
		
		function Save()
		{			
			$codigoLote = $this->BoletoLote_GetGenerator();
			
			if (!$this->UpdateSequenciaBoleto(	$this->Cobrador->CodigoCobrador, 
												$this->Cobrador->SequenciaNossoNumero, 
												$this->Cobrador->SequenciaNossoNumeroInc)) 
			{
				return false;
			}
										 
			for ($i = 0; $i < count($this->ListBoleto); $i++)
			{
				$boleto = $this->ListBoleto[$i];
				$boleto->CodigoBoleto 	= $this->BoletoDebaut_GetGenerator();
				$boleto->CodigoCobrador = $this->Cobrador->CodigoCobrador;
				$boleto->CodigoConta 	= $this->Cobrador->CodigoConta;
				$boleto->TipoCobrador 	= $this->Cobrador->TipoCobrador;
				$boleto->Funcionario	= 999999;
				$boleto->Impresso		= 1;
				$boleto->CodigoLote		= $codigoLote;
				
				$DataLanc = Array();
				$DataInst = Array();
				
				for ($j = 0; $j < count($boleto->LancamentoFinanceiro); $j++)
				{
					$DataLanc[$j]['CD_BOLETOS_DEBAUT_DISC']  = $this->BoletoDebautDisc_GetGenerator();
					$DataLanc[$j]['CD_BOLETOS_DEBAUT']       = $boleto->CodigoBoleto;
					$DataLanc[$j]['CD_BOLETOS_LOTE']         = $boleto->CodigoLote;
					$DataLanc[$j]['NOSSO_NUMERO']            = $boleto->NossoNumero;
					$DataLanc[$j]['NR_LANCAMENTO']           = $boleto->LancamentoFinanceiro[$j];
					$DataLanc[$j]['SEQUENCIA']               = 0;
					$DataLanc[$j]['SEQBOLETO']               = 0;
					$DataLanc[$j]['VALOR']                   = 0;
				}
								
				for ($i = 1; $i <= count($this->ListBoleto); $i++)
				{
					$method1 = 'InstrucaoTmp'.$i;
					$method2 = 'InstrucaoTipoTmp'.$i;
					
					if ($boleto->$method1 != '')
					{
						$j = count($DataInst);
						$DataInst[$j]['CD_BOLETOS_DEBAUT_INSTR'] = $this->BoletoInstrucao_GetGenerator();
						$DataInst[$j]['CD_BOLETOS_DEBAUT']       = $boleto->CodigoBoleto;
						$DataInst[$j]['INSTRUCAO']               = $this->StringUtil->DBString($boleto->$method1);
						$DataInst[$j]['TIPO']                    = $boleto->$method2;
						$DataInst[$j]['ORDEM']                   = $i;
					}          
				}
				
				$this->oConexao->Conecta();
				$this->oConexao->BeginTrans();
				
				$ret0 = $this->BoletoLote_Insert($codigoLote);
				$ret1 = $this->BoletoDebaut_Insert($boleto);
				$ret2 = $this->BoletoLancamento_Insert($DataLanc);
				$ret3 = $this->BoletoInstrucao_Insert($DataInst);
				
				if ($ret0 && $ret1 && $ret2 && $ret3) 
				{
					$this->oConexao->Commit();
					$this->oConexao->Desconecta();
					return true;
				}
				else
				{
					$this->oConexao->Rollback();
					$this->oConexao->Desconecta();
					
					if (!$ret0) echo "erro ret0<br>";
					if (!$ret1) echo "erro ret1<br>";
					if (!$ret2) echo "erro ret2<br>";
					if (!$ret3) echo "erro ret3<br>";
					
					return false;
				}
			}
		}
		
		function BoletoLote_Insert($codigoLote)
		{
			$DataMovimento = date('Y-m-d');
			
			$sql = "
				INSERT INTO TB_BOLETOS_LOTE (CD_BOLETOS_LOTE, DATAMOVIMENTO, QTDE_BOLETOS,   
				QTDE_LANCAMENTOS, CD_USUARIO, CD_COBRADOR, CD_CONTA, CD_REMESSA, IMPRESSO)   		
				VALUES (
				". $codigoLote .",
				". $this->StringUtil->DBString($DataMovimento) .",
				". 1 .",
				". 0 .",  		
				". 999999 .",
				". $this->Cobrador->CodigoCobrador .", 
				". $this->Cobrador->CodigoConta .", 
				". "null" .",
				". 1 .") ";
				
			$arr = $this->oConexao->Execute($sql);
			$afetados = $this->oConexao->RegistrosAfetados();
			return $afetados >= 1;
		}

		function BoletoInstrucao_Insert($DataInst)
		{		
			if (count($DataInst) == 0) 
				return true;
			
			$afetados = 0 ;
			foreach($DataInst as $row) {
		
				$sql = "
					INSERT INTO TB_BOLETOS_DEBAUT_INSTR (CD_BOLETOS_DEBAUT_INSTR, CD_BOLETOS_DEBAUT, INSTRUCAO, ORDEM, TIPO)
					VALUES (
					". $row['CD_BOLETOS_DEBAUT_INSTR'] .", 
					". $row['CD_BOLETOS_DEBAUT'] .",  
					". $this->StringUtil->DBString($row['INSTRUCAO']) .", 
					". $row['ORDEM'] .",
					". $row['TIPO'] .")";
						
				$arr = $this->oConexao->Execute($sql);
				$afetados .= $this->oConexao->RegistrosAfetados();
			}
				
			return $afetados >= 1;
		}
		 
		function BoletoLancamento_Insert($DataLanc)
		{		
			$afetados = 0 ;
			foreach($DataLanc as $row) {
		
				$sql = "
				 INSERT INTO TB_BOLETOS_DEBAUT_DISC (NOSSO_NUMERO, SEQBOLETO, NR_LANCAMENTO,          
				 SEQUENCIA, VALOR, CD_BOLETOS_DEBAUT_DISC, CD_BOLETOS_DEBAUT, CD_BOLETOS_LOTE)        
				 VALUES (
				 ". $this->StringUtil->DBString($row['NOSSO_NUMERO']) .", 
				 ". $row['SEQBOLETO'] .", 
				 ". $row['NR_LANCAMENTO'] .",                                   
				 ". $row['SEQUENCIA'] .", 
				 ". $this->StringUtil->DBDecimal($row['VALOR']) .", 
				 ". $row['CD_BOLETOS_DEBAUT_DISC'] .", 
				 ". $row['CD_BOLETOS_DEBAUT'] .", 
				 ". $row['CD_BOLETOS_LOTE'] .")";
		
				$arr = $this->oConexao->Execute($sql);
				$afetados .= $this->oConexao->RegistrosAfetados();
			}
							
			return $afetados >= 1;
		}	
		
		function BoletoDebaut_Insert($boleto)
		{						
			if ($boleto->DataLimiteDesconto1 == 0) 	$boleto->DataLimiteDesconto1 = null;
			if ($boleto->DataLimiteDesconto2 == 0) 	$boleto->DataLimiteDesconto2 = null;
			if ($boleto->DataLimiteDesconto3 == 0) 	$boleto->DataLimiteDesconto3 = null;
			if ($boleto->DataEmissao == 0) 			$boleto->DataEmissao = null;
			if ($boleto->DataVencimento == 0) 		$boleto->DataVencimento = null;
			if ($boleto->DataVencimentoU == 0) 		$boleto->DataVencimentoU = null;
			if ($boleto->DataDocumento == 0) 		$boleto->DataDocumento = null;
			if ($boleto->DataProcessamento == 0) 	$boleto->DataProcessamento = null;
			if ($boleto->DataMulta == 0) 			$boleto->DataMulta = null;	

			$sql = "
			 INSERT INTO TB_BOLETOS_DEBAUT (CD_BOLETOS_DEBAUT, CD_BOLETOS_LOTE, SEQUENCIA, CODIGO, CD_COBRADOR, CD_CONTA, CD_BANCO,                 
			 CD_AGENCIA, NR_AGENCIA, NR_AGENCIA_DV, NR_CC, NR_CC_DV, NR_AGENCIA_CC_DV, LINHA_DIGITAVEL, CODIGO_BARRAS, NOSSO_NUMERO,                
			 NOSSO_NUMERO_SEM_DV, NOSSO_NUMERO_FORMATO, NOSSO_NUMERO_SEQUENCIA, LOCALPAGAMENTO1, NUMERODOC,                                         
			 DT_EMISSAO, DT_VENCIMENTO, DT_VENCIMENTOU, DT_DOCUMENTO, DT_PROCESSAMENTO, DT_MULTA, DT_IMPRESSAO, DT_BAIXA, DT_LIMITE_DES_1,          
			 DT_LIMITE_DES_2, DT_LIMITE_DES_3, VALOR, MULTA, JUROS, DESCONTO, VALORTOTAL, VR_IOF, VR_ABATIMENTO, VALORPRINCIPAL,                    
			 VR_TARIFA, QUANTIDADEMOEDA, VALORMOEDA, CONVENIO, POSTO, TIPOCOBRANCA, CARTEIRA, ACEITE, ESPECIE,                                      
			 ESPECIEDOC, TIPOIMPRESSAO, EMISSAOBOLETO, ENTREGABOLETO, INSTRUCAOCOBRANCA1, INSTRUCAOCOBRANCA2, DIASPROTESTO, DIASBAIXA,              
			 TIPOMULTA, TIPOJUROS, TIPODESCONTO,                                                                                                    
			 CODIGOCEDENTE, NOMECEDENTE, CNPJCEDENTE, ENDERECOCEDENTE, BAIRROCEDENTE, CIDADECEDENTE, UFCEDENTE, CEPCEDENTE,                         
			 FONECEDENTE, EMAILCEDENTE, NOMESACADO, CNPJSACADO, ENDERECOSACADO, BAIRROSACADO, CIDADESACADO,                                         
			 UFSACADO, CEPSACADO, FONESACADO, EMAILSACADO, INSTRUCAOREM1, INSTRUCAOREM2, INSTRUCAOREM3, INSTRUCAOREM4,                              
			 INSTRUCAOREM5, INSTRUCAOREM6, INSTRUCAOREM7, INSTRUCAOREM8, INSTRUCAOREM9, INSTRUCAOREM10, INSTRUCAOREM11,                             
			 INSTRUCAO1, INSTRUCAO2, INSTRUCAO3, INSTRUCAO4, INSTRUCAO5, INSTRUCAO6, INSTRUCAO7, INSTRUCAO8, INSTRUCAO9, INSTRUCAO10, INSTRUCAO11,  
			 CD_FUNC, IMPRESSO, CODIGOOCORRENCIA, MOTIVOOCORRENCIA,                                                                                 
			 ST_BOLETO, TP_LANCAMENTO, NR_PARCELA,                                                                                                  
			 NOMESACADORAVALISTA, CNPJSACADORAVALISTA, ENDERECOSACADORAVALISTA, BAIRROSACADORAVALISTA,                                              
			 CIDADESACADORAVALISTA, UFSACADORAVALISTA, CEPSACADORAVALISTA) VALUES (			 
			 ". $boleto->CodigoBoleto .", 
			 ". $boleto->CodigoLote .", 
			 ". "1" .", 
			 ". $boleto->Sacado_CodigoSysClub .", 
			 ". $boleto->CodigoCobrador .", 
			 ". $boleto->CodigoConta .", 
			 ". $this->StringUtil->DBString($boleto->Banco) .",                 
			 ". "null" .", 
			 ". $this->StringUtil->DBString($boleto->Agencia) .", 
			 ". $this->StringUtil->DBString($boleto->AgenciaDv) .", 
			 ". $this->StringUtil->DBString($boleto->Conta) .", 
			 ". $this->StringUtil->DBString($boleto->ContaDv) .", 
			 ". $this->StringUtil->DBString($boleto->AgenciaContaDv) .", 
			 ". $this->StringUtil->DBString($boleto->LinhaDigitavel) .", 
			 ". $this->StringUtil->DBString($boleto->CodigoBarras) .", 
			 ". $this->StringUtil->DBString($boleto->NossoNumero) .",                
			 ". $this->StringUtil->DBString($boleto->NossoNumeroSemDV) .", 
			 ". $this->StringUtil->DBString($boleto->NossoNumeroFormatado) .", 
			 ". $this->StringUtil->DBString($boleto->SequenciaNossoNumero) .", 
			 ". $this->StringUtil->DBString($boleto->LocalPagamento) .", 
			 ". "null" .",                                         
			 ". $this->StringUtil->DBDate($boleto->DataEmissao) .", 
			 ". $this->StringUtil->DBDate($boleto->DataVencimento) .", 
			 ". $this->StringUtil->DBDate($boleto->DataVencimentoU) .", 
			 ". $this->StringUtil->DBDate($boleto->DataDocumento) .", 
			 ". $this->StringUtil->DBDate($boleto->DataProcessamento) .", 
			 ". $this->StringUtil->DBDate($boleto->DataMulta) .", 
			 ". $this->StringUtil->DBDate($boleto->DataEmissao) .", 
			 ". "null" .", 
			 ". $this->StringUtil->DBDate($boleto->DataLimiteDesconto1) .",          
			 ". $this->StringUtil->DBDate($boleto->DataLimiteDesconto2) .", 
			 ". $this->StringUtil->DBDate($boleto->DataLimiteDesconto3) .", 
			 ". $this->StringUtil->DBDecimal($boleto->ValorBoleto) .", 
			 ". $this->StringUtil->DBDecimal($boleto->VlrOuPercMultaAtraso) .", 
			 ". $this->StringUtil->DBDecimal($boleto->VlrOuPercJurosDiaAtraso) .", 
			 ". $this->StringUtil->DBDecimal($boleto->VlrOuPercDesconto) .", 
			 ". $this->StringUtil->DBDecimal($boleto->ValorBoleto) .", 
			 ". $this->StringUtil->DBDecimal($boleto->ValorIof) .", 
			 ". $this->StringUtil->DBDecimal($boleto->ValorAbatimento) .", 
			 ". $this->StringUtil->DBDecimal($boleto->ValorPrincipal) .",                    
			 ". $this->StringUtil->DBDecimal($boleto->ValorTarifa) .", 
			 ". $this->StringUtil->DBString($boleto->Quantidade) .", 
			 ". $this->StringUtil->DBString($boleto->ValorMoeda) .", 
			 ". $this->StringUtil->DBString($boleto->Convenio) .", 
			 ". $this->StringUtil->DBString($boleto->Posto) .", 
			 ". $this->StringUtil->DBString($boleto->TipoCobranca) .", 
			 ". $this->StringUtil->DBString($boleto->Carteira) .", 
			 ". $this->StringUtil->DBString($boleto->Aceite) .", 
			 ". $this->StringUtil->DBString($boleto->Especie) .",                                      
			 ". $this->StringUtil->DBString($boleto->EspecieDoc) .", 
			 ". $this->StringUtil->DBString($boleto->TipoImpressao) .", 
			 ". $this->StringUtil->DBString($boleto->EmissaoBoleto) .", 
			 ". $this->StringUtil->DBString($boleto->EntregaBoleto) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoCobranca1) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoCobranca2) .", 
			 ". $this->StringUtil->DBInt($boleto->DiasProtesto) .", 
			 ". $this->StringUtil->DBInt($boleto->DiasBaixa) .",              
			 ". $this->StringUtil->DBString($boleto->TipoMulta) .", 
			 ". $this->StringUtil->DBString($boleto->TipoJuros) .", 
			 ". $this->StringUtil->DBString($boleto->TipoDesconto) .",   
			 ". $this->StringUtil->DBString($boleto->Cedente_Codigo) .", 				   
			 ". $this->StringUtil->DBString($boleto->Cedente_Nome) .",                       
			 ". $this->StringUtil->DBString($boleto->Cedente_CpfCnpj) .",                    
			 ". $this->StringUtil->DBString($boleto->Cedente_Endereco) .",                    
			 ". $this->StringUtil->DBString($boleto->Cedente_Bairro) .",                 
			 ". $this->StringUtil->DBString($boleto->Cedente_Cidade) .",                   
			 ". $this->StringUtil->DBString($boleto->Cedente_Uf) .",                       
			 ". $this->StringUtil->DBString($boleto->Cedente_Cep) .",                                
			 ". $this->StringUtil->DBString($boleto->Cedente_Telefone) .", 
			 ". $this->StringUtil->DBString($boleto->Cedente_Email) .", 
			 ". $this->StringUtil->DBString($boleto->Sacado_Nome) .", 			    
			 ". $this->StringUtil->DBString($boleto->Sacado_CpfCnpj) .",            
			 ". $this->StringUtil->DBString($boleto->Sacado_Endereco) .",            
			 ". $this->StringUtil->DBString($boleto->Sacado_Bairro) .",         
			 ". $this->StringUtil->DBString($boleto->Sacado_Cidade) .",                                           
			 ". $this->StringUtil->DBString($boleto->Sacado_Uf) .",               
			 ". $this->StringUtil->DBString($boleto->Sacado_Cep) .",                  
			 ". $this->StringUtil->DBString($boleto->Sacado_Telefone) .", 
			 ". $this->StringUtil->DBString($boleto->Sacado_Email) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa1) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa2) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa3) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa4) .",                              
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa5) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa6) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa7) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa8) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa9) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa10) .", 
			 ". $this->StringUtil->DBString($boleto->InstrucaoRemessa11) .",    
			 ". $this->StringUtil->DBString($boleto->Instrucao1) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao2) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao3) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao4) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao5) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao6) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao7) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao8) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao9) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao10) .", 
			 ". $this->StringUtil->DBString($boleto->Instrucao11) .",  
			 ". $this->StringUtil->DBString($boleto->Funcionario) .", 
			 ". $boleto->Impresso .", 
			 ". "null" .", 
			 ". "null" .",                                                                                 
			 ". "null" .", 
			 ". $this->StringUtil->DBString("B") .", 
			 ". $this->StringUtil->DBString($boleto->NumeroParcela) .",       
			 ". $this->StringUtil->DBString($boleto->SacadorAvalista_Nome) .", 
			 ". $this->StringUtil->DBString($boleto->SacadorAvalista_CpfCnpj) .", 
			 ". $this->StringUtil->DBString($boleto->SacadorAvalista_Endereco) .", 
			 ". $this->StringUtil->DBString($boleto->SacadorAvalista_Bairro) .",                                              
			 ". $this->StringUtil->DBString($boleto->SacadorAvalista_Cidade) .", 
			 ". $this->StringUtil->DBString($boleto->SacadorAvalista_Uf) .", 
			 ". $this->StringUtil->DBString($boleto->SacadorAvalista_Cep) .")";
			
			$arr = $this->oConexao->Execute($sql);
			$afetados = $this->oConexao->RegistrosAfetados();
				
			return $afetados == 1;
		}

		function GetValorPagarReceber($lancamentos, $dataVencimento) 
		{	
			$sql = " SELECT SUM(T1.VALOR) AS VALOR FROM TB_PAGAR_RECEBER_NV T1 WHERE T1.NR_LANCAMENTO IN ($lancamentos) ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();
					
			$valor = 0.00 ;
			foreach($arr as $row) {
				$valor = $valor + round($row['VALOR'], 2);
			}		
			return $valor;
		}
		
		function AtualizaValor($lancamentos, $dataVencimento)
		{	
			$sql  = "";
			$sql  .= " SELECT                                                                                            	";
			$sql  .= "   T1.DT_VENCIMENTO,                                                                                  ";
			$sql  .= "   CASE                                                                                               ";
			$sql  .= "     WHEN T1.DT_VENCIMENTO < '$dataVencimento' THEN    										 		";
			$sql  .= " 		(SELECT T2.VR_ATUALIZADO FROM PR_ATUALIZA_LANCAMENTO(T1.NR_LANCAMENTO, '$dataVencimento') T2) 	";
			$sql  .= "     ELSE T1.VALOR                                                                                    ";
			$sql  .= "   END AS VALORATUALIZADO                                                                             ";
			$sql  .= " FROM                                                                                                 ";
			$sql  .= "   TB_PAGAR_RECEBER_NV T1                                                                             ";
			$sql  .= " WHERE                                                                                                ";
			$sql  .= "   T1.NR_LANCAMENTO IN ($lancamentos)                                                                 ";
			$sql  .= " ORDER BY                                                                                             ";
			$sql  .= "   T1.NR_LANCAMENTO                                                                                   ";
			
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();
			
			$valor = 0.0 ;
			foreach($arr as $row){
				$valor = $valor + round($row['VALORATUALIZADO'], 2);
			}
			return $valor;
		}
		
		function GetMaiorVencimento($lancamentos)
		{
			$sql = " SELECT MAX(DT_VENCIMENTO) AS RET FROM TB_PAGAR_RECEBER_NV WHERE NR_LANCAMENTO IN ($lancamentos) ";
			
			$this->oConexao->Conecta();
			$arr = $this->oConexao->toArray($sql);
			$this->oConexao->Desconecta();
			
			$data = 0 ;
			foreach($arr as $row){
				$data = $row['RET'];
			}
			
			return $data;
		}
		
		function logMsg( $msg, $level = 'info', $file = 'main.log' )
		{
			// variável que vai armazenar o nível do log (INFO, WARNING ou ERROR)
			$levelStr = '';
		 
			// verifica o nível do log
			switch ( $level )
			{
				case 'info':
					// nível de informação
					$levelStr = 'INFO';
					break;
		 
				case 'warning':
					// nível de aviso
					$levelStr = 'WARNING';
					break;
		 
				case 'error':
					// nível de erro
					$levelStr = 'ERROR';
					break;
			}
		 
			// data atual
			$date = date( 'Y-m-d H:i:s' );
		 
			// formata a mensagem do log
			// 1o: data atual
			// 2o: nível da mensagem (INFO, WARNING ou ERROR)
			// 3o: a mensagem propriamente dita
			// 4o: uma quebra de linha
			$msg = sprintf( "[%s] [%s]: %s%s", $date, $levelStr, $msg, PHP_EOL );
		 
			// escreve o log no arquivo
			// é necessário usar FILE_APPEND para que a mensagem seja escrita no final do arquivo, preservando o conteúdo antigo do arquivo
			file_put_contents( $file, $msg, FILE_APPEND );
		}
	}
	
?>