<?php
	
	require_once('../sysclub_functions/functions.php');
	require_once('conexao.php');
	require_once('cob_cobranca.php');
	require_once('stringutil.php'); 

	try 
	{
		$server = new SOAPServer(null, array('uri' => 'http://localhost', 'encoding'=>'ISO-8859-1'));
		$server->setClass('Servico');
		$server->handle();
	} 
	catch (SOAPFault $f) 
	{
		print $f->faultstring;
	}

    class Servico 
    {
        public function Login($usuario, $senha)
        {
			$usuarioUpper = strtoupper($usuario);
			$senhaUpper = strtoupper($senha);

			$sql = "SELECT TD.*, E.* FROM TB_TITULAR_DEPENDENTE TD INNER JOIN TB_ENTIDADE E ON (E.CODIGO = TD.CODIGO) WHERE TD.ATIVO = 'A' AND ((login = '$usuario' AND SENHA = '$senha') or (login = '$usuarioUpper' AND SENHA = '$senhaUpper')) AND SENHA <> '' AND login <> '' AND NOT login IS null";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

            if (count($arr) == 1)
				return array("Codigo" => $arr[0]["CODIGO"], "Nome" => $arr[0]["NM_ENTIDADE"]); 
			return null;
        }

        public function isSocio($cpf, $titulo)
        {
			$sql = " 
				SELECT
				  TD.NR_COTA AS TITULO,
				  TD.DV_COTA AS SERIE,
				  TD.CPF,
				  TD.NM_ENTIDADE AS NOME,
				  TD.DT_NASC AS DATA_NASCIMENTO,
				  TD.CODIGO AS N_SOCIO,
				  TD.FONE AS CONTATO,
				  TD.E_MAIL AS EMAIL,
				  TD.DT_CADASTRO AS DATA_INSCRICAO,
				  CASE
					WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
					ELSE '0'
					END AS TITULAR,
				  TD.SEXO,
				  (SELECT FIRST 1 RS.NR_RANKING FROM TB_RANKING_SOCIO RS WHERE RS.CODIGO = TD.CODIGO ORDER BY RS.SEQUENCIA DESC) AS RANKING
				FROM
				  VW_SOCIO TD
				WHERE
				  TD.NR_COTA = $titulo AND
				  TD.ATIVO = 'A' AND
				  TD.STATUS = 'V'";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			foreach($arr as $row)
			{
				$tmp1 = $row['CPF'];
				$tmp1 = str_replace("/","", str_replace("-","",str_replace(".","", $tmp1)));

				$tmp2 = $cpf;
				$tmp2 = str_replace("/","", str_replace("-","",str_replace(".","", $tmp2)));

				if ($tmp1 == $tmp2)
				{
					return to_utf8( array (	"NOME"				=> $row["NOME"], 
											"TITULO"			=> $row["TITULO"],
											"SERIE"				=> $row["SERIE"],
											"DATA_NASCIMENTO"	=> $row["DATA_NASCIMENTO"],
											"N_SOCIO"			=> $row["N_SOCIO"],
											"CONTATO"			=> $row["CONTATO"],
											"EMAIL"				=> $row["EMAIL"],
											"DATA_INSCRICAO"	=> $row["DATA_INSCRICAO"],
											"TITULAR"			=> $row["TITULAR"],
											"SEXO"				=> $row["SEXO"],
											"RANKING"			=> $row["RANKING"] )); 
				}
			}
			return array();
        }

		public function isSocioPorTitulo($titulo)
        {
			$sql = " 
				SELECT
				  TD.NR_COTA AS TITULO,
				  TD.DV_COTA AS SERIE,
				  TD.CPF,
				  TD.NM_ENTIDADE AS NOME,
				  TD.DT_NASC AS DATA_NASCIMENTO,
				  TD.CODIGO AS N_SOCIO,
				  TD.FONE AS CONTATO,
				  TD.E_MAIL AS EMAIL,
				  TD.DT_CADASTRO AS DATA_INSCRICAO,
				  CASE
					WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
					ELSE '0'
					END AS TITULAR,
				  TD.SEXO,
				  (SELECT FIRST 1 RS.NR_RANKING FROM TB_RANKING_SOCIO RS WHERE RS.CODIGO = TD.CODIGO ORDER BY RS.SEQUENCIA DESC) AS RANKING
				FROM
				  VW_SOCIO TD
				WHERE
				  TD.NR_COTA = $titulo AND
				  TD.ATIVO = 'A' AND
				  TD.STATUS = 'V'";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			foreach($arr as $row)
			{
				return to_utf8( array (	"NOME"				=> $row["NOME"], 
										"TITULO"			=> $row["TITULO"],
										"SERIE"				=> $row["SERIE"],
										"DATA_NASCIMENTO"	=> $row["DATA_NASCIMENTO"],
										"N_SOCIO"			=> $row["N_SOCIO"],
										"CONTATO"			=> $row["CONTATO"],
										"EMAIL"				=> $row["EMAIL"],
										"DATA_INSCRICAO"	=> $row["DATA_INSCRICAO"],
										"TITULAR"			=> $row["TITULAR"],
										"SEXO"				=> $row["SEXO"],
										"RANKING"			=> $row["RANKING"] )); 
			}
			return array();
        }

        public function IdentificarSocio($titulo, $datanascimento)
        {
			$dateExplode =  explode ('/', $datanascimento);

			$dia = $dateExplode[0];
			$mes = $dateExplode[1]; 
			$ano = $dateExplode[2];

			$datanascimento = $ano ."-". $mes ."-". $dia;

			$sql = "SELECT S.CODIGO FROM VW_SOCIO S WHERE S.ATIVO = 'A' AND S.NR_COTA = '". $titulo ."' AND S.DT_NASC = '". $datanascimento ."'";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			if (count($arr) >= 1) {
				$sql = "SELECT S.CODIGO FROM VW_SOCIO S WHERE S.ATIVO = 'A' AND S.NR_COTA = '". $titulo ."' AND S.DT_NASC = '". $datanascimento ."' AND S.CODIGO = S.CD_TITULAR ";

				$oConexao = new Conexao();
				$oConexao->Conecta();
				$arr = $oConexao->toArray($sql);
				$oConexao->Desconecta();			
			}
			
			if (count($arr) == 1) {
                return $arr[0]["CODIGO"];
			}
            return -1;
        }

        public function IdentificarSocioRg($rg, $datanascimento)
        {
			$teste = preg_split ('[/]', $datanascimento);

			$dia = $teste[0];
			$mes = $teste[1]; 
			$ano = $teste[2];

			$datanascimento = $ano ."/". $mes ."/". $dia;

			$sql = "SELECT * FROM VW_SOCIO S WHERE S.ATIVO = 'A' AND S.RG = '". $rg ."' AND S.DT_NASC = '". $datanascimento ."'";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			if (count($arr) == 1)
                return $arr[0]["CODIGO"];
            return -1;
        }

        public function ListaDependentes($codigo)
        {
			$sql = "";
			$sql .=  " SELECT						";
			$sql .=  "   S.codigo,					";
			$sql .=  "   S.nm_entidade				";
			$sql .=  " FROM							";
			$sql .=  "   vw_socio s					";
			$sql .=  " where						";
			$sql .=  "   S.ATIVO = 'A' AND			";
 			$sql .=  "   S.cd_titular = $codigo  	";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

            return to_utf8($arr);
        }

        public function GetDadosFinanceiro($codigo)
        {
			$sql = " SELECT																					";
			$sql .=  "  p.*,																				";
			$sql .=  "  (select vr_atualizado from pr_atualiza_lancamento(p.nr_lancamento,'". date('Y/m/d') ."')) as valoratualizado, ";
			$sql .=  "  t.nm_tipo_documento,																";
			$sql .=  "  c.nm_entidade,																		";
			$sql .=  "  c.nr_cota,																			";
			$sql .=  "  c.dv_cota																		    ";
			$sql .=  " from																					";
			$sql .=  "  Tb_Pagar_Receber_NV p															    ";
			$sql .=  "  inner join Vw_Clientes c on (c.codigo = p.codigo)								    ";
			$sql .=  "  inner join Tb_Tipo_Documento t on (t.cd_tipo_documento = p.cd_tipo_documento)		";
			$sql .=  " WHERE																				";
			$sql .=  "  p.tp_lancamento = 'R' AND														    ";
			$sql .=  "  c.codigo = ". $codigo ." AND														";
			$sql .=  "  p.dt_acerto is null AND																";
			$sql .=  "  p.st_lancamento is null																";
			$sql .=  " ORDER BY																				";
			$sql .=  "  p.dt_vencimento																		";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

            return to_utf8($arr);
        }

        public function GetDadosFinanceiroMensal($codigo)
        {
			$sql = "";
			$sql .= " SELECT											";
			$sql .= "   REF,											";
			$sql .= "	MESANO,											";
			$sql .= "	CODIGO,											";
			$sql .= "   SUM(VALOR) AS TOTAL_LANCAMENTO,					";
			$sql .= "   SUM(VR_BAIXA) AS TOTAL_BAIXADO					";
 			$sql .= " FROM												";
			$sql .= "   (												";
			$sql .= "   SELECT											";
			$sql .= "     EXTRACT( YEAR FROM P.DT_LANCAMENTO) || '/' || LPAD(EXTRACT( MONTH FROM P.DT_LANCAMENTO), 2, '0') AS REF, ";
			$sql .= "     LPAD( EXTRACT( MONTH FROM P.DT_LANCAMENTO), 2, '0') || '/' || EXTRACT( YEAR FROM P.DT_LANCAMENTO) AS MESANO, ";
			$sql .= "     P.CODIGO,										";
			$sql .= "     P.VALOR,										";
			$sql .= "     P.VR_BAIXA									";
			$sql .= "   FROM											";
			$sql .= "     TB_PAGAR_RECEBER_NV P							";	                                     
			$sql .= "     INNER JOIN TB_TIPO_DOCUMENTO T ON (T.CD_TIPO_DOCUMENTO = P.CD_TIPO_DOCUMENTO) ";        
			$sql .= "   WHERE											";	
			$sql .= "     P.CODIGO = $codigo AND						";
			$sql .= "     P.TP_LANCAMENTO = 'R' AND                     ";                                       
			$sql .= "     P.ST_LANCAMENTO IS null						";
			$sql .= "   ORDER BY										";
			$sql .= "     P.DT_LANCAMENTO								";
			$sql .= "   )												";
			$sql .= " GROUP BY											";
			$sql .= "   REF, MESANO, CODIGO								";	
			$sql .= " ORDER BY											";
			$sql .= "   REF	DESC										";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

            return to_utf8($arr);
        }

		public function GetDadosFinanceiroMensalDetalhado($codigo, $mesano)
        {
			$mes = substr($mesano, 0, 2);
			$ano = substr($mesano, 3, 4);

			$ultimo_dia = date("t", mktime(0, 0, 0, $mes, '01', $ano)); 

			$dataLancamentoInicio = date('Y-m-d', mktime(0,0,0,$mes, '01', $ano));
			$dataLancamentoFinal  = date('Y-m-d', mktime(0,0,0, $mes, $ultimo_dia, $ano));

			$sql = "";
 			$sql .= "      SELECT																";
			$sql .= "         T2.CODIGO,														";
			$sql .= "         T2.NR_CRACHA,														";
			$sql .= "         T2.NR_COTA,														";
			$sql .= "         T3.NM_ENTIDADE,													";
			$sql .= "         T4.CD_CONTA,														";		
			$sql .= "         T4.NM_CONTA,														";	
			$sql .= "         T1.VALOR_LC AS VALOR												";			
			$sql .= "       FROM																";	
			$sql .= "         VW_RECEBER T1														";
			$sql .= "         LEFT JOIN TB_TITULAR_DEPENDENTE T2 ON (T2.CODIGO = T1.CODIGO_PR)	";
			$sql .= "         LEFT JOIN TB_ENTIDADE T3 ON (T3.CODIGO = T1.CODIGO_PR)			";
			$sql .= "         LEFT JOIN TB_CONTA T4 ON (T4.CD_CONTA = T1.CD_CONTA)				";
			$sql .= "       WHERE																";
			$sql .= "         T1.CODIGO_PR = $codigo AND										";
			$sql .= "         T1.DT_LANCAMENTO_PR >= '$dataLancamentoInicio' AND				";		
			$sql .= "         T1.DT_LANCAMENTO_PR <= '$dataLancamentoFinal'						";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

            return to_utf8($arr);
        }

        public function AlterarSenha($codigo, $login, $senha)
        {
			$loginUpper = strtoupper($login);

            $sql = "
				
				UPDATE 
				  TB_TITULAR_DEPENDENTE 
				SET 
				  LOGIN = '". $login ."', 
				  SENHA = '". $senha ."' 
				WHERE 
				  NOT EXISTS (SELECT * FROM TB_TITULAR_DEPENDENTE TD_TMP WHERE TD_TMP.LOGIN = '". $loginUpper ."' AND TD_TMP.LOGIN = '". $login ."' AND TD_TMP.CODIGO <> ". $codigo .") AND
				  CODIGO = ". $codigo ."
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$res = $oConexao->Execute($sql);
			$afetados = $oConexao->RegistrosAfetados();
			$oConexao->Desconecta();

			if ($afetados == 1)
				return 1;
			else
				return 0;
        }

        public function getSocio($titulo)
        {
			$sql = " 
				SELECT
				  TD.NR_COTA AS TITULO,
				  TD.DV_COTA AS SERIE,
				  TD.NM_ENTIDADE AS NOME,
				  TD.DT_NASC AS DATA_NASCIMENTO,
				  TD.CODIGO AS N_SOCIO,
				  TD.FONE AS CONTATO,
				  TD.E_MAIL AS EMAIL,
				  TD.DT_CADASTRO AS DATA_INSCRICAO,
				  CASE
					WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
					ELSE '0'
					END AS TITULAR,
				  TD.SEXO,
				  (SELECT FIRST 1 RS.NR_RANKING FROM TB_RANKING_SOCIO RS WHERE RS.CODIGO = TD.CODIGO ORDER BY RS.SEQUENCIA DESC) AS RANKING
				FROM
				  VW_SOCIO TD
				WHERE
				  TD.CODIGO = $titulo AND
				  TD.ATIVO = 'A' AND
				  TD.STATUS = 'V'
			";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
        }

        public function getTodosSocios($titular)
        {
			$sql = " 
				SELECT
				  TD.NR_COTA AS TITULO,
				  TD.DV_COTA AS SERIE,
				  TD.NM_ENTIDADE AS NOME,
				  TD.DT_NASC AS DATA_NASCIMENTO,
				  TD.CODIGO AS N_SOCIO,
				  TD.FONE AS CONTATO,
				  TD.E_MAIL AS EMAIL,
				  TD.DT_CADASTRO AS DATA_INSCRICAO,
				  CASE
					WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
					ELSE '0'
					END AS TITULAR,
				  TD.SEXO,
				  (SELECT FIRST 1 RS.NR_RANKING FROM TB_RANKING_SOCIO RS WHERE RS.CODIGO = TD.CODIGO ORDER BY RS.SEQUENCIA DESC) AS RANKING
				FROM
				  VW_SOCIO TD
				WHERE
				  TD.CD_TITULAR = $titular AND
				  TD.ATIVO = 'A' AND
				  TD.STATUS = 'V'
			";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
        }

        public function getTodosSociosAniversariantesNoMes($mes)
        {
			$sql = " 
                SELECT
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  TD.NM_ENTIDADE AS NOME,
                  TD.DT_NASC AS DATA_NASCIMENTO,
                  TD.CODIGO AS N_SOCIO,
                  TD.FONE AS CONTATO,
                  TD.E_MAIL AS EMAIL,
                  CASE
                    WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
                    ELSE '0'
                    END AS TITULAR,
                  TD.SEXO
                FROM
                  VW_SOCIO TD
                WHERE
                  EXTRACT(MONTH FROM TD.DT_NASC) = ". $mes ." AND
                  TD.ATIVO = 'A' AND
                  TD.STATUS = 'V'";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
        }

        public function getTodosSociosAniversariantesNoMesDia($mes, $dia)
        {
			$sql = " 
                SELECT
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  TD.NM_ENTIDADE AS NOME,
                  TD.DT_NASC AS DATA_NASCIMENTO,
                  TD.CODIGO AS N_SOCIO,
                  TD.FONE AS CONTATO,
                  TD.E_MAIL AS EMAIL,
                  CASE
                    WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
                    ELSE '0'
                    END AS TITULAR,
                  TD.SEXO
                FROM
                  VW_SOCIO TD
                WHERE
                  EXTRACT(MONTH FROM TD.DT_NASC) = ". $mes ." AND
				  EXTRACT(DAY FROM TD.DT_NASC) = ". $dia ." AND
                  TD.ATIVO = 'A' AND
                  TD.STATUS = 'V'
			";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
        }

		// BOLETO

		function GetBoletoInscricaoFutebol($codigo, $codigoInscricao)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 

			$this->setNullTituloExcluidoPorInscricao($codigoInscricao);

			$oConexao = new Conexao();

			$sql = "
				SELECT
					CI.*,
					PR.CD_COBRADOR,
					PR.DT_VENCIMENTO,
					PR.ST_LANCAMENTO
				FROM
					TB_CAMPEONATO_INSCRICAO CI
					LEFT JOIN TB_PAGAR_RECEBER_NV PR ON (PR.NR_LANCAMENTO = CI.NR_LANCAMENTO)
				WHERE
  					PR.st_lancamento is null AND
					CI.CODIGO = '". $codigo ."' AND
					CI.CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."' ";

			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();
			
			if (count($arr) == 1)
			{
				$codigoCampeonato = $arr[0]["CD_CAMPEONATO"];
				$codigoCategoria  = $arr[0]["CD_CATEGORIA"]; 
				
				if (($arr[0]["NR_LANCAMENTO"] == null) or 
				    ($arr[0]["NR_LANCAMENTO"] == 0) or 
				    ($arr[0]["NR_LANCAMENTO"] == "") or
				    ($arr[0]["ST_LANCAMENTO"] == "D"))
				{
					// GERAR FINANCEIRO

					// PEGA COBRADOR
					$cd_cobrador = $this->GetCobrador();
		

					// PEGAR PRECO DA INSCRICAO
					$sql = "SELECT * FROM TB_CAMPEONATO_CATEGORIAS CC WHERE CC.CD_CATEGORIA = '". $codigoCategoria ."' ";

					$oConexao->Conecta();
					$arr = $oConexao->toArray($sql);
					$oConexao->Desconecta();
					
					if (count($arr) == 1)
						$codigoTabelaPreco = $arr[0]["CD_AVULSO"];
					else 
						throw new Exception('Nao foi encontrato o categoria do campeonato... ');

					$sql = "
						SELECT * FROM
						  TB_PRECO_AVULSOS PA
						  LEFT JOIN TB_PRECO_AVULSOS_VALORES PAV ON (PAV.CD_AVULSO = PA.CD_AVULSO)
						WHERE
						  PA.ST_AVULSO IS null AND
						  PAV.ST_AVULSO IS null AND
						  PA.CD_AVULSO = '". $codigoTabelaPreco ."' ";

					$oConexao->Conecta();
					$arr = $oConexao->toArray($sql);
					$oConexao->Desconecta();

					if (count($arr) >= 1)
					{
						$valor			= $arr[0]["VR_AVULSO"];
						$cd_conta		= $arr[0]["CD_CONTA"];
						$cd_centrocusto	= $arr[0]["CD_CENTROCUSTO"];
					} 
					else 
						throw new Exception('Nao conseguiu pegar preco ... ');

					
					// GEN NUMERO LANCAMENTO
				
					$sql = "SELECT GEN_ID(GN_PAGAR_RECEBER,1) AS CODIGO FROM RDB\$DATABASE ";

					$oConexao->Conecta();
					$arr = $oConexao->toArray($sql);
					$oConexao->Desconecta();

					if (count($arr) >= 1)
						$nr_lancamento = $arr[0]["CODIGO"] ;	
					else 
						throw new Exception('Nao conseguiu gerar numero de lancamento ... ');

					$tp_lancamento		= "R";
					$descricao			= "BOLETO DE INSCRICAO VIA SITE";
					$cd_tipo_documento	= "12";
					$dt_lancamento		= Date("Y-m-d");
					$dt_vencimento		= Date("Y-m-d", strtotime("+2 days"));
					$perc_multa			= 0;
					$perc_juros			= 0;
					$perc_desconto		= 0;
					$referente			= "";

					$sql = "INSERT INTO TB_PAGAR_RECEBER_NV (NR_LANCAMENTO, TP_LANCAMENTO, CODIGO, CD_COBRADOR, DESCRICAO, CD_TIPO_DOCUMENTO, DT_LANCAMENTO, DT_VENCIMENTO, VALOR, PERC_MULTA, PERC_JUROS, PERC_DESCONTO, REFERENTE) VALUES ('". $nr_lancamento ."' ,'". $tp_lancamento ."' ,'". $codigo ."' ,'". $cd_cobrador ."' ,'". $descricao ."', '". $cd_tipo_documento ."' ,'". $dt_lancamento ."' ,'". $dt_vencimento ."' ,'". $valor ."', '". $perc_multa ."' ,'". $perc_juros ."' ,'". $perc_desconto ."' ,'". $referente ."')";

					$oConexao->Conecta();
					$res1 = $oConexao->Execute($sql);
					$afetados1 = $oConexao->RegistrosAfetados();
					$oConexao->Desconecta();

					if ($afetados1 <= 0) 
						throw new Exception('Erro ... 1 ');

					$sequencia			= 1;
					$dt_base			= Date('Y-m-d'); 
					$multa				= 0 ;
					$juros				= 0 ;  
					$desconto			= 0 ;
					$cd_auxiliar1		= $codigoCampeonato;
					$cd_auxiliar2		= 0;  
					$cd_auxiliar3		= 0;  
					$st_lancamento		= "P";

					$sql = "";
					$sql .= "INSERT INTO TB_LANCAMENTOS (NR_LANCAMENTO, SEQUENCIA, CODIGO, CD_COBRADOR, DT_BASE, DT_LANCAMENTO, 					";
					$sql .= "CD_CONTA, CD_CENTROCUSTO, VALOR, MULTA, JUROS, DESCONTO, CD_AUXILIAR1, CD_AUXILIAR2, CD_AUXILIAR3, ST_LANCAMENTO) 		";
					$sql .= "VALUES ('". $nr_lancamento ."','". $sequencia ."' ,'". $codigo ."' ,'". $cd_cobrador ."' ,'". $dt_base ."' ,			";
					$sql .= "'". $dt_lancamento ."', '". $cd_conta ."' ,'". $cd_centrocusto ."' ,'". $valor ."' ,'". $multa ."' ,'".  $juros ."',	";
					$sql .= "'". $desconto ."','". $cd_auxiliar1 ."' ,'".  $cd_auxiliar2 ."' ,'". $cd_auxiliar3 ."' ,'". $st_lancamento ."')		";

					$oConexao->Conecta();
					$res2 = $oConexao->Execute($sql);
					$afetados2 = $oConexao->RegistrosAfetados();
					$oConexao->Desconecta();

					if ($afetados2 <= 0) 
						throw new Exception('Erro ... 2 ');

					$sql = "UPDATE TB_CAMPEONATO_INSCRICAO SET NR_LANCAMENTO = '". $nr_lancamento ."' WHERE (CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."')	";
					
					$oConexao->Conecta();
					$res3 = $oConexao->Execute($sql);					
					$afetados3 = $oConexao->RegistrosAfetados();
					$oConexao->Desconecta();

					if ($afetados3 <= 0) 
						throw new Exception('Erro ... 3 ');
				}
				else
				{
					$nr_lancamento = $arr[0]["NR_LANCAMENTO"];
					$dt_vencimento = Date("Y-m-d", strtotime("+2 days"));
				}
				
				return $this->GetBoleto($nr_lancamento);
			} 
			return array();
		}

		private function GetCobrador()
		{
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray("SELECT * FROM TB_COBRADOR WHERE BOLETOONLINE = 1");
			$oConexao->Desconecta();
			
			if (count($arr) != 1)
				throw new Exception("Não existe cobrador para impressão ONLINE");
			
			return $arr[0]["CD_COBRADOR"];
		}
		
		function ExisteBoletoParaLancamento($NumerosLancamento, $codigoCobrador)
		{
			$dataBase = Date("Y-m-d");
				
			$sql = " SELECT COUNT(*) AS QTDE FROM TB_PAGAR_RECEBER_NV PR WHERE PR.NR_LANCAMENTO IN ($NumerosLancamento) ";
			
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();
			
			$quantidade = $arr[0]["QTDE"];
			
			$sql = "";		
			$sql .= "  SELECT																				";
			$sql .= "    CD_BOLETOS_DEBAUT, NOSSO_NUMERO                                                    ";
			$sql .= "  FROM                                                                                 ";
			$sql .= "  (                                                                                    ";
			$sql .= "    SELECT B.CD_BOLETOS_DEBAUT, B.NOSSO_NUMERO FROM                                    ";
			$sql .= "      TB_BOLETOS_DEBAUT_DISC BDD                                                       ";
			$sql .= "      INNER JOIN TB_BOLETOS_DEBAUT B ON (B.CD_BOLETOS_DEBAUT = BDD.CD_BOLETOS_DEBAUT)  ";
			$sql .= "    WHERE                                                                              ";
			$sql .= "      BDD.NR_LANCAMENTO IN ($NumerosLancamento) AND  	                                ";
			$sql .= "      B.CD_COBRADOR = $codigoCobrador AND  	                                    	";
			$sql .= "      B.DT_VENCIMENTO >= '$dataBase' AND												";
			$sql .= "      B.ST_BOLETO IS NULL																";
			$sql .= "    GROUP BY                                                                           ";
			$sql .= "      B.CD_BOLETOS_DEBAUT,                                                             ";
			$sql .= "      B.NOSSO_NUMERO                                                                   ";
			$sql .= "  ) AS RET                                                                             ";
			$sql .= "  WHERE                                                                                ";
			$sql .= "    (SELECT COUNT(*) FROM                                                              ";
			$sql .= "       TB_BOLETOS_DEBAUT_DISC TMP                                                      ";
			$sql .= "     WHERE                                                                             ";
			$sql .= "       TMP.CD_BOLETOS_DEBAUT = RET.CD_BOLETOS_DEBAUT AND								";
			$sql .= "       TMP.NR_LANCAMENTO IN ($NumerosLancamento)) = $quantidade                        ";
			$sql .= "  ORDER BY                                                                             ";
			$sql .= "    CD_BOLETOS_DEBAUT DESC																";
 			
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();
			
			return $arr;
		}
		
		function GetBoleto($lancamentos)
        {
			$oCobranca = new TBCobranca();
			$StringUtil = new StringUtil();
			
			// cobrador para impressao na internet
			$codigoCobrador = $this->GetCobrador();
			
			// carregando boletos existentes		
			$arrBoletos = $this->ExisteBoletoParaLancamento($lancamentos, $codigoCobrador);	
						
			if (count($arrBoletos) >= 1)
			{
				try 
				{
					$oCobranca->ClearListBoleto();
					$oCobranca->CodigoCobrador = $codigoCobrador;
					$oCobranca->CarregarDadosCobrador($codigoCobrador);
					$oCobranca->LoadPorCodigoBoleto($arrBoletos[0]["CD_BOLETOS_DEBAUT"]);
					return $oCobranca->ListBoleto;
				}
				catch (Exception $e) 
				{
					throw new Exception('Erro gerando o boleto...' .$e->getMessage());
				}
			}
			
			$oCobranca->ClearListBoleto();
			$oCobranca->CodigoCobrador = $codigoCobrador;
			$oCobranca->CarregarDadosCobrador($codigoCobrador);
			$oCobranca->CalcularJuro = true ;
			$oCobranca->TipoVencimento = 2 ;
			$oCobranca->ImprimirComJuros = true;
			$oCobranca->Agrupado = true ;
			
			$sql = "";
			$sql .= " SELECT  																															";						
			$sql .= "   (SELECT dt_util FROM PR_PROXIMO_DIAUTIL(PR.DT_VENCIMENTO)) AS DT_VENCIMENTOU, 								                    ";
			$sql .= "   (SELECT VR_ATUALIZADO FROM PR_ATUALIZA_LANCAMENTO(PR.NR_LANCAMENTO, CURRENT_TIMESTAMP)) AS VALORATUALIZADO,                     ";
			$sql .= "   PR.NR_LANCAMENTO,																							 	                ";
			$sql .= "   PR.DT_VENCIMENTO, 	                    																	                    ";
			$sql .= "   PR.DESCRICAO, 		                    																	                    ";
			$sql .= "   PR.NR_PARCELA, 		                    																	                    ";
			$sql .= "   PR.PERC_JUROS, 		                    																	                    ";
			$sql .= "   PR.PERC_MULTA, 		                    																	                    ";
			$sql .= "   PR.PERC_DESCONTO, 	                    																	                    ";
			$sql .= "   PR.VALOR, 			                    																	                    ";
			$sql .= "   PR.REFERENTE, 		                    																	                    ";
			$sql .= "   PR.NR_DOC, 			                    																	                    ";
			$sql .= "   E.*, TD.*, PF.*, PJ.*, C.*, 																				                    ";
			$sql .= "   '' AS COMPLEMENTO,																							                    ";
			$sql .= "   (SELECT FIRST 1 TMP.LOGRADOURO FROM PR_ENDERECO_SOCIO(E.CODIGO, TD.CD_TITULAR) TMP  WHERE TMP.END_CORRESP = 'T' ) AS LOGRADOURO,";
			$sql .= "   (SELECT FIRST 1 TMP.BAIRRO FROM PR_ENDERECO_SOCIO(E.CODIGO, TD.CD_TITULAR) TMP WHERE TMP.END_CORRESP = 'T' ) AS BAIRRO,         ";
			$sql .= "   (SELECT FIRST 1 TMP.CIDADE FROM PR_ENDERECO_SOCIO(E.CODIGO, TD.CD_TITULAR) TMP  WHERE TMP.END_CORRESP = 'T' ) AS CIDADE,        ";
			$sql .= "   (SELECT FIRST 1 TMP.UF FROM PR_ENDERECO_SOCIO(E.CODIGO, TD.CD_TITULAR) TMP  WHERE TMP.END_CORRESP = 'T' ) AS UF,                ";
			$sql .= "   (SELECT FIRST 1 TMP.CEP FROM PR_ENDERECO_SOCIO(E.CODIGO, TD.CD_TITULAR) TMP WHERE TMP.END_CORRESP = 'T' ) AS CEP,               ";
			$sql .= "   (SELECT FIRST 1 PF2.CPF FROM TB_PESSOA_FISICA PF2 WHERE PF2.CODIGO = TD.CD_TITULAR) AS CPF_RESPONS,                             ";
			$sql .= "   (SELECT FIRST 1 EN2.NM_ENTIDADE FROM TB_ENTIDADE EN2 WHERE EN2.CODIGO = TD.CD_TITULAR) AS NOME_RESPONS,                         ";
			$sql .= "   TD.NR_AGENCIA AS SACADO_NR_AGENCIA,                             																";
			$sql .= "   TD.NR_AGENCIA_DV AS SACADO_NR_AGENCIA_DV,                                                                                       ";
			$sql .= "   TD.NR_CC AS SACADO_NR_CC,                                                                                                       ";
			$sql .= "   TD.NR_CC_DV AS SACADO_NR_CC_DV	  								                                                                ";
			$sql .= " FROM                                                                                                                              ";
			$sql .= "   TB_PAGAR_RECEBER_NV PR                                                                                                          ";
			$sql .= "   LEFT JOIN TB_TITULAR_DEPENDENTE TD ON (TD.CODIGO = PR.CODIGO)  	                                                                ";
			$sql .= "   LEFT JOIN TB_ENTIDADE E ON (E.CODIGO = PR.CODIGO)                                                                               ";
			$sql .= "   LEFT JOIN TB_PESSOA_FISICA PF ON (E.CODIGO = PF.CODIGO)                                                                         ";
			$sql .= "   LEFT JOIN TB_PESSOA_JURIDICA PJ ON (E.CODIGO = PJ.CODIGO)                                                                       ";
			$sql .= "   LEFT JOIN TB_CATEGORIA C ON (C.CD_CATEGORIA = TD.CD_CATEGORIA)                                                                  ";
			$sql .= " WHERE 1 = 1                                                                                                                       ";
			$sql .= "   AND PR.NR_LANCAMENTO IN ($lancamentos)                                                                                          ";
			$sql .= "   AND PR.tp_lancamento = 'R'                                                                                                      ";
			$sql .= "   AND PR.dt_acerto IS null										                                                                ";
			$sql .= "   AND PR.st_lancamento IS null                                                                                                    ";
			$sql .= " ORDER BY                                                                                                                          ";
			$sql .= "   TD.DV_COTA,                                                                                                                     ";
			$sql .= "   TD.NR_COTA_ORDER,                                                                                                               ";
			$sql .= "   E.CODIGO,                                                                                                                       ";
			$sql .= "   PR.NR_PARCELA,                                                                                                                  ";
			$sql .= "   PR.DT_VENCIMENTO                                                                                                                ";
			
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();
			
			$codigoUltimo = -1;
			
			foreach($arr as $row)
			{ 
				if ($oCobranca->Agrupado) 
				{
					if ($codigoUltimo != $row['CODIGO']) 
					{
						$boleto = $oCobranca->AddBoleto();
						$boleto->ValorBoleto    = 0.0;
						$boleto->ValorPrincipal = 0.0;
					}
				}
				else  
				{
					$boleto = $oCobranca->AddBoleto();
					$boleto->ValorBoleto    = 0.0;
					$boleto->ValorPrincipal = 0.0;
				}
				
				$codigoUltimo = $row['CODIGO'];
			
				$boleto->NumeroDocumento        = $row['NR_DOC'] ;
				$boleto->Sacado_CodigoSysClub   = $row['CODIGO'] ;
				$boleto->Sacado_Nome            = $row['NM_ENTIDADE'] ;
				
				if (($row['FISICA_JURIDICA'] == 'F') && ($StringUtil->SoNumeros($row['CPF']) != '')) {
					$boleto->Sacado_CpfCnpj = $row['CPF'];
				} else if (($row['FISICA_JURIDICA'] == 'J') && ($StringUtil->SoNumeros($row['CNPJ']) != '')) {
					$boleto->Sacado_CpfCnpj = $row['CNPJ'];
				} else {
					if ($row['NOME_RESPONS'] 	!= '') $boleto->Sacado_Nome 	= $row['NOME_RESPONS'] ;
					if ($row['CPF_RESPONS'] 	!= '') $boleto->Sacado_CpfCnpj 	= $row['CPF_RESPONS'] ;
					if ($row['NM_RESPONSAVEL'] 	!= '') $boleto->Sacado_Nome 	= $row['NM_RESPONSAVEL'] ;
					if ($row['CPF_RESPONSAVEL'] != '') $boleto->Sacado_CpfCnpj 	= $row['CPF_RESPONSAVEL'] ;
				}

				// SACADO
				$boleto->Sacado_Endereco         	= $row['LOGRADOURO'] ;
				$boleto->Sacado_Bairro            	= $row['BAIRRO'] ;
				$boleto->Sacado_Cidade            	= $row['CIDADE'] ;
				$boleto->Sacado_Uf                	= $row['UF'] ;
				$boleto->Sacado_Cep               	= $row['CEP'] ;
				$boleto->Sacado_Titulo            	= $row['NR_COTA'] .' - '. $row['DV_COTA'];
				$boleto->Sacado_NumeroCota        	= $row['NR_COTA'] ;
				$boleto->Sacado_DigitoCota        	= $row['DV_COTA'] ;
				$boleto->Sacado_Agencia           	= $row['SACADO_NR_AGENCIA'] ;
				$boleto->Sacado_Agencia_DV        	= $row['SACADO_NR_AGENCIA_DV'] ;
				$boleto->Sacado_ContaCorrente     	= $row['SACADO_NR_CC'] ;
				$boleto->Sacado_ContaCorrente_DV  	= $row['SACADO_NR_CC_DV'] ;

				$boleto->InstrucaoRemessa11       	= $row['DESCRICAO'] ;
				$boleto->DataVencimento           	= $row['DT_VENCIMENTO'] ;
				$boleto->DataVencimentoU          	= $row['DT_VENCIMENTOU'] ;
				$boleto->VlrOuPercMultaAtraso     	= $row['PERC_MULTA'] ;
				$boleto->VlrOuPercDesconto        	= $row['PERC_DESCONTO'] ;
				$boleto->VlrOuPercJurosDiaAtraso  	= $row['PERC_JUROS'] ;
				$boleto->NumeroParcela            	= $row['NR_PARCELA'] ;

				$boleto->SequenciaNossoNumero     	= $oCobranca->ProximoSequenciaNossoNumero() ;

				if ($boleto->DataVencimento < $row['DT_VENCIMENTO'])
					$boleto->DataVencimento = $row['DT_VENCIMENTO'];

				if ($boleto->VlrOuPercMultaAtraso < $row['PERC_MULTA'] )
					$boleto->VlrOuPercMultaAtraso = $row['PERC_MULTA'];

				if ($boleto->VlrOuPercJurosDiaAtraso < $row['PERC_JUROS'])
					$boleto->VlrOuPercJurosDiaAtraso = $row['PERC_JUROS'];

				if ($boleto->VlrOuPercDesconto < $row['PERC_DESCONTO'])
					$boleto->VlrOuPercDesconto = $row['PERC_DESCONTO'];

				$boleto->ValorBoleto    += $row['VALORATUALIZADO'] ;
				$boleto->ValorPrincipal += $row['VALOR'] ;	
				$boleto->AddLancamentoFinanceiro($row['NR_LANCAMENTO']);
			}
			try 
			{				
				$oCobranca->Prepare();
				if ($oCobranca->Save()) {
					return $oCobranca->ListBoleto;
				} else {
					throw new Exception('Não conseguiu salvar o boleto...');
				}
			}
			catch (Exception $e) 
			{
				throw new Exception('Erro gerando o boleto...' .$e->getMessage());
			}
        }
		
		// FUTEBOL
        public function IdentificarSocioFutebol($codigoSocio, $cpf, $titulo)
        {
			
			$sql = "
				SELECT
                  TD.CODIGO,
                  E.NM_ENTIDADE AS NOME,
				  PF.CPF,
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  CT.CD_TIME,
                  CT.CD_GRUPO,
                  CT.CD_CAMPEONATO,
                  CT.CODIGO_REPRESENTANTE1 AS CODIGO_REPRESENTANTE1,
                  CT.CODIGO_REPRESENTANTE2 AS CODIGO_REPRESENTANTE2,
                  CT.CODIGO_REPRESENTANTE3 AS CODIGO_REPRESENTANTE3
                FROM
                  TB_TITULAR_DEPENDENTE TD
                  INNER JOIN TB_ENTIDADE E ON (E.CODIGO = TD.CODIGO)
				  INNER JOIN TB_PESSOA_FISICA PF ON (PF.CODIGO = TD.CODIGO) 
                  INNER JOIN TB_CAMPEONATO_TIME_ATLETAS CTA ON (CTA.CODIGO = TD.CODIGO)
                  INNER JOIN TB_CAMPEONATO_TIMES CT ON (CT.CD_CAMPEONATO = CTA.CD_CAMPEONATO AND CT.CD_TIME = CTA.CD_TIME)
                  INNER JOIN TB_CAMPEONATO C ON (CTA.CD_CAMPEONATO = C.CD_CAMPEONATO)				  
				WHERE 
                                  C.IN_ATIVO = 'T' AND 
				  TD.CODIGO = $codigoSocio AND
				  TD.NR_COTA = '$titulo' AND
				  TD.ATIVO = 'A' AND
				  TD.STATUS = 'V'				
			";	
  
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();
			
			return to_utf8($arr);
        }

        public function LoginFutebol($usuario, $senha)
        {
			$usuarioUpper = strtoupper($usuario);
			$senhaUpper = strtoupper($senha);
			
			$sql = "
				SELECT
					TD.CODIGO,
					E.NM_ENTIDADE AS NOME,
					TD.NR_COTA AS TITULO,
					TD.DV_COTA AS SERIE,

				  (SELECT
					 FIRST 1 CT.CD_TIME
				   FROM
					 TB_CAMPEONATO C
					 INNER JOIN TB_CAMPEONATO_TIME_ATLETAS CTA ON (CTA.CD_CAMPEONATO = C.CD_CAMPEONATO)
					 INNER JOIN TB_CAMPEONATO_TIMES CT ON (CT.CD_CAMPEONATO = CTA.CD_CAMPEONATO AND CT.CD_TIME = CTA.CD_TIME)
				   WHERE
					 CTA.CODIGO = TD.CODIGO AND C.IN_ATIVO = 'T'
				   ORDER BY
					 C.CD_CAMPEONATO DESC
				   ) AS CD_TIME,

				  (SELECT
					 FIRST 1 CT.CD_GRUPO
				   FROM
					 TB_CAMPEONATO C
					 INNER JOIN TB_CAMPEONATO_TIME_ATLETAS CTA ON (CTA.CD_CAMPEONATO = C.CD_CAMPEONATO)
					 INNER JOIN TB_CAMPEONATO_TIMES CT ON (CT.CD_CAMPEONATO = CTA.CD_CAMPEONATO AND CT.CD_TIME = CTA.CD_TIME)
				   WHERE
					 CTA.CODIGO = TD.CODIGO AND C.IN_ATIVO = 'T'
				   ORDER BY
					 C.CD_CAMPEONATO DESC
				   ) AS CD_GRUPO,

				  (SELECT
					 FIRST 1 CT.CD_CAMPEONATO
				   FROM
					 TB_CAMPEONATO C
					 INNER JOIN TB_CAMPEONATO_TIME_ATLETAS CTA ON (CTA.CD_CAMPEONATO = C.CD_CAMPEONATO)
					 INNER JOIN TB_CAMPEONATO_TIMES CT ON (CT.CD_CAMPEONATO = CTA.CD_CAMPEONATO AND CT.CD_TIME = CTA.CD_TIME)
				   WHERE
					 CTA.CODIGO = TD.CODIGO AND C.IN_ATIVO = 'T'
				   ORDER BY
					 C.CD_CAMPEONATO DESC
				   ) AS CD_CAMPEONATO,

				  (SELECT
					 FIRST 1 CT.CODIGO_REPRESENTANTE1
				   FROM
					 TB_CAMPEONATO C
					 INNER JOIN TB_CAMPEONATO_TIME_ATLETAS CTA ON (CTA.CD_CAMPEONATO = C.CD_CAMPEONATO)
					 INNER JOIN TB_CAMPEONATO_TIMES CT ON (CT.CD_CAMPEONATO = CTA.CD_CAMPEONATO AND CT.CD_TIME = CTA.CD_TIME)
				   WHERE
					 CTA.CODIGO = TD.CODIGO AND C.IN_ATIVO = 'T'
				   ORDER BY
					 C.CD_CAMPEONATO DESC
				   ) AS CODIGO_REPRESENTANTE1,

				  (SELECT
					 FIRST 1 CT.CODIGO_REPRESENTANTE2
				   FROM
					 TB_CAMPEONATO C
					 INNER JOIN TB_CAMPEONATO_TIME_ATLETAS CTA ON (CTA.CD_CAMPEONATO = C.CD_CAMPEONATO)
					 INNER JOIN TB_CAMPEONATO_TIMES CT ON (CT.CD_CAMPEONATO = CTA.CD_CAMPEONATO AND CT.CD_TIME = CTA.CD_TIME)
				   WHERE
					 CTA.CODIGO = TD.CODIGO AND C.IN_ATIVO = 'T'
				   ORDER BY
					 C.CD_CAMPEONATO DESC
				   ) AS CODIGO_REPRESENTANTE2,

				  (SELECT
					 FIRST 1 CT.CODIGO_REPRESENTANTE3
				   FROM
					 TB_CAMPEONATO C
					 INNER JOIN TB_CAMPEONATO_TIME_ATLETAS CTA ON (CTA.CD_CAMPEONATO = C.CD_CAMPEONATO)
					 INNER JOIN TB_CAMPEONATO_TIMES CT ON (CT.CD_CAMPEONATO = CTA.CD_CAMPEONATO AND CT.CD_TIME = CTA.CD_TIME)
				   WHERE
					 CTA.CODIGO = TD.CODIGO AND C.IN_ATIVO = 'T'
				   ORDER BY
					 C.CD_CAMPEONATO DESC
				   ) AS CODIGO_REPRESENTANTE3

				FROM
				  TB_TITULAR_DEPENDENTE TD
				  INNER JOIN TB_ENTIDADE E ON (E.CODIGO = TD.CODIGO)
				WHERE 
			      ((login = '$usuario' AND SENHA = '$senha') or 
				   (login = '$usuarioUpper' AND SENHA = '$senhaUpper')) AND 
				  SENHA <> '' AND login <> '' AND NOT login IS NULL 
			";
  
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

            if (count($arr) == 1)
				return to_utf8($arr);

			return null;
        }
		
        public function LoginFutebolAll($usuario, $senha)
        {
			$usuarioUpper = strtoupper($usuario);
			$senhaUpper   = strtoupper($senha);
			
			$sql = "
                SELECT
                  TD.CODIGO,
                  E.NM_ENTIDADE AS NOME,
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  CT.CD_TIME,
                  CT.CD_GRUPO,
                  CT.CD_CAMPEONATO,
                  CT.CODIGO_REPRESENTANTE1 AS CODIGO_REPRESENTANTE1,
                  CT.CODIGO_REPRESENTANTE2 AS CODIGO_REPRESENTANTE2,
                  CT.CODIGO_REPRESENTANTE3 AS CODIGO_REPRESENTANTE3
                FROM
                  TB_TITULAR_DEPENDENTE TD
                  INNER JOIN TB_ENTIDADE E ON (E.CODIGO = TD.CODIGO)
                  INNER JOIN TB_CAMPEONATO_TIME_ATLETAS CTA ON (CTA.CODIGO = TD.CODIGO)
                  INNER JOIN TB_CAMPEONATO_TIMES CT ON (CT.CD_CAMPEONATO = CTA.CD_CAMPEONATO AND CT.CD_TIME = CTA.CD_TIME)
                  INNER JOIN TB_CAMPEONATO C ON (CTA.CD_CAMPEONATO = C.CD_CAMPEONATO)
				WHERE 
			      ((login = '$usuario' AND SENHA = '$senha') or 
				   (login = '$usuarioUpper' AND SENHA = '$senhaUpper')) AND 
				  SENHA <> '' AND login <> '' AND NOT login IS NULL AND C.IN_ATIVO = 'T'
			";
  
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
        }

		function GetAllCampeonato()
		{
			$sql = "
                	SELECT 
                  	  C.*,
                  	  CC.NM_CATEGORIA,
                  	  CC.CD_CATEGORIA
                	FROM
                  	  TB_CAMPEONATO C
                   	  LEFT JOIN TB_CAMPEONATO_CATEGORIAS CC ON (CC.CD_CATEGORIA = C.CD_CATEGORIA)
                	WHERE
                  	  C.IN_ATIVO = 'T'
                	  ORDER BY
                  	  CC.NM_CATEGORIA,
                  	  C.CD_CATEGORIA
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetGrupos($campeonato, $campeonatoAtivo)
		{
			$sql = "
                    SELECT 
                        C.*,
                        CG.NM_GRUPO,
                        CG.CD_GRUPO
                    FROM
                        TB_CAMPEONATO C
						LEFT JOIN TB_CAMPEONATO_GRUPOS CG ON (CG.CD_CAMPEONATO = C.CD_CAMPEONATO)
                    WHERE 
						C.CD_CAMPEONATO = $campeonato
			";
					
			if ($campeonatoAtivo == 1)
			{
				$sql .= " AND C.IN_ATIVO = 'T' ";
			}
			
			$sql .= "	
                    ORDER BY
                        C.CD_CAMPEONATO,
                        CG.NM_GRUPO
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetTimes($campeonato)
		{
			$sql = "SELECT * FROM TB_CAMPEONATO_TIMES CT WHERE CT.CD_CAMPEONATO = $campeonato ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetTimesPorGrupo($campeonato, $grupo)
		{
			$sql = "
				SELECT 
					* 
				FROM 
					TB_CAMPEONATO_TIMES CT 
				WHERE 
					CT.CD_CAMPEONATO = $campeonato 
			";

			if ($grupo > 0)
			{
				$sql .= " AND CT.CD_GRUPO = $grupo ";	
			}
			
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetTime($codigoTime)
		{
			$sql = "  
				SELECT 
				  CT.*, CG.NM_GRUPO 
				FROM																								 
			      TB_CAMPEONATO_TIMES CT																					 
				  LEFT JOIN TB_CAMPEONATO_GRUPOS CG ON (CG.CD_GRUPO = CT.CD_GRUPO AND CG.CD_CAMPEONATO = CT.CD_CAMPEONATO) 
			    WHERE 
				  CT.CD_TIME = '". $codigoTime ."' 
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetClassificacao($campeonato)
		{
			$sql = " SELECT * FROM TB_CAMPEONATO_CRITERIOS CC ORDER BY CC.CD_CRITERIO ";
			
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			$order = "";

			for ($i = 0; $i < count($arr); $i++)
			{
				$order .= $arr[$i]['SQL'];
				if ($i < (count($arr)-1))
					$order .= ",";
			}

			$sql = "
			  SELECT 
				CD_CATEGORIA,
				NM_CATEGORIA,
				CD_GRUPO,
				NM_GRUPO,
				CD_TIME,
				NM_TIME,
				QT_PONTOS,
				QT_JOGOS,
				QT_VITORIAS,
				QT_EMPATES,
				QT_DERROTAS,
				QT_GOLS_PRO,
				QT_GOLS_CONTRA,
				QT_SALDO_GOLS,
				((QT_PONTOS / 100) * (QT_JOGOS * 3)) AS PERCENTUAL
			  FROM   
				PR_CAMPEONATO_CLASSIFICACAO ($campeonato) CC
			  ORDER BY
				$order
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetClassificacaoPorGrupo($campeonato, $grupo)
		{
			$sql = " SELECT * FROM TB_CAMPEONATO_CRITERIOS CC ORDER BY CC.CD_CRITERIO ";
			
			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			$order = "";

			for ($i = 0; $i < count($arr); $i++)
			{
				$order .= $arr[$i]['SQL'];
				if ($i < (count($arr)-1))
					$order .= ",";
			}

			$sql = "
			  SELECT 
				CD_CATEGORIA,
				NM_CATEGORIA,
				CD_GRUPO,
				NM_GRUPO,
				CD_TIME,
				NM_TIME,
				QT_PONTOS,
				QT_JOGOS,
				QT_VITORIAS,
				QT_EMPATES,
				QT_DERROTAS,
				QT_GOLS_PRO,
				QT_GOLS_CONTRA,
				QT_SALDO_GOLS,
				((QT_PONTOS / 100) * (QT_JOGOS * 3)) AS PERCENTUAL
			  FROM   
				PR_CAMPEONATO_CLASSIFICACAO ($campeonato) CC
			  WHERE 
			    CC.CD_GRUPO = $grupo
			  ORDER BY
				$order
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetRodadasCampeonato($campeonato)
		{
			$sql = "
				SELECT
				  CJ.NR_RODADA,
				  -1 as STATUS,
				  '' AS DT_JOGO
				FROM
				  TB_CAMPEONATO_JOGOS CJ
				WHERE
				  CJ.NR_RODADA < 999 and
				  CJ.CD_CAMPEONATO = $campeonato
				GROUP BY
				  CJ.NR_RODADA
				ORDER BY
				  CJ.NR_RODADA
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			for ($i = 0; $i < count($arr); $i++)
			{
				$rodada = $arr[$i]['NR_RODADA'];

				$sql = "
					select 
					(SELECT
					  COUNT(*) 
					FROM
					  TB_CAMPEONATO_JOGOS CJ
					WHERE
					  CJ.STATUS = 1 AND
					  CJ.NR_RODADA = $rodada AND
					  CJ.CD_CAMPEONATO = $campeonato) AS STATUS_1,

					(SELECT
					  COUNT(*) 
					FROM
					  TB_CAMPEONATO_JOGOS CJ
					WHERE
					  CJ.STATUS = 2 AND
					  CJ.NR_RODADA = $rodada AND
					  CJ.CD_CAMPEONATO = $campeonato) AS STATUS_2,

					(SELECT
					  COUNT(*) 
					FROM
					  TB_CAMPEONATO_JOGOS CJ
					WHERE
					  CJ.STATUS = 3 AND
					  CJ.NR_RODADA = $rodada AND
					  CJ.CD_CAMPEONATO = $campeonato) AS STATUS_3,

					(SELECT
					  COUNT(*) 
					FROM
					  TB_CAMPEONATO_JOGOS CJ
					WHERE
					  CJ.STATUS = 4 AND
					  CJ.NR_RODADA = $rodada AND
					  CJ.CD_CAMPEONATO = $campeonato) AS STATUS_4,

                    			(
                    				SELECT
                      					FIRST 1 CJ.DT_JOGO
                    				FROM
                      					TB_CAMPEONATO_JOGOS CJ
                    				WHERE
                      					CJ.NR_RODADA = $rodada AND
                      					CJ.CD_CAMPEONATO = $campeonato
                    				ORDER BY
                      					CJ.DT_JOGO DESC
                    			) AS DT_JOGO


					FROM TB_CAMPEONATO C WHERE C.CD_CAMPEONATO = $campeonato";

				$oConexao->Conecta();
				$x = $oConexao->toArray($sql);
				$oConexao->Desconecta();

				if ($x[0]['STATUS_1'] > 0)
					$arr[$i]['STATUS'] = 1;
				if ($x[0]['STATUS_2'] > 0)
					$arr[$i]['STATUS'] = 2;
				if ($x[0]['STATUS_3'] > 0)
					$arr[$i]['STATUS'] = 3;
				if ($x[0]['STATUS_4'] > 0)
					$arr[$i]['STATUS'] = 4;

				
				$arr[$i]['DT_JOGO'] = $x[0]['DT_JOGO'];
			}

			return to_utf8($arr) ;
		}

		function GetJogosDoCampeonato($campeonato)
		{
			$sql = "
				SELECT
				  CJ.CD_CAMPEONATO,
				  CJ.NR_RODADA,
				  CJ.NR_JOGO,
				  CJ.NR_CAMPO,
				  CJ.QT_GOLS1,
				  CJ.QT_GOLS2,
				  CJ.STATUS,
				  CT1.CD_TIME AS CD_TIME1,
				  CT2.CD_TIME AS CD_TIME2,
				  CT1.NM_TIME AS NM_TIME1,
				  CT2.NM_TIME AS NM_TIME2,
				  DT_JOGO,
				  HR_JOGO
				FROM
				  TB_CAMPEONATO_JOGOS CJ
				  LEFT JOIN TB_CAMPEONATO_TIMES CT1 ON (CT1.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT1.CD_TIME = CJ.CD_TIME1)
				  LEFT JOIN TB_CAMPEONATO_TIMES CT2 ON (CT2.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT2.CD_TIME = CJ.CD_TIME2)
				WHERE
				  CJ.CD_CAMPEONATO = $campeonato and
				  CJ.NR_RODADA < 999
				ORDER BY
				  CJ.DT_JOGO";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetJogosDoCampeonatoGrupoTime($campeonato, $grupo, $time)
		{
			$sql = "
				SELECT
				  CJ.CD_CAMPEONATO,
				  CJ.NR_RODADA,
				  CJ.NR_JOGO,
				  CJ.NR_CAMPO,
				  CJ.QT_GOLS1,
				  CJ.QT_GOLS2,
				  CJ.STATUS,
				  CT1.CD_TIME AS CD_TIME1,
				  CT2.CD_TIME AS CD_TIME2,
				  CT1.NM_TIME AS NM_TIME1,
				  CT2.NM_TIME AS NM_TIME2,
				  DT_JOGO,
				  HR_JOGO,
				  CJ.CD_GRUPO
				FROM
				  TB_CAMPEONATO_JOGOS CJ
				  LEFT JOIN TB_CAMPEONATO_TIMES CT1 ON (CT1.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT1.CD_TIME = CJ.CD_TIME1)
				  LEFT JOIN TB_CAMPEONATO_TIMES CT2 ON (CT2.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT2.CD_TIME = CJ.CD_TIME2)
				WHERE
				  CJ.CD_CAMPEONATO = $campeonato ";
			
			if ($grupo > 0)
			{
				$sql .= " AND CJ.CD_GRUPO = $grupo ";	
			}
	
			if ($time > 0)
			{
				$sql .= " AND ((CJ.CD_TIME1 = $time) OR (CJ.CD_TIME2 = $time))  ";	
			}
				  
			$sql .= "
				  AND CJ.NR_RODADA < 999
				ORDER BY
				  CJ.DT_JOGO
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetJogosDaRodada($campeonato, $rodada)
		{
			$sql = "
				SELECT
				  CJ.CD_CAMPEONATO,
				  CJ.NR_RODADA,
				  CJ.NR_JOGO,
				  CJ.NR_CAMPO,
				  CJ.QT_GOLS1,
				  CJ.QT_GOLS2,
				  CJ.STATUS,
				  CT1.CD_TIME AS CD_TIME1,
				  CT2.CD_TIME AS CD_TIME2,
				  CT1.NM_TIME AS NM_TIME1,
				  CT2.NM_TIME AS NM_TIME2,
				  DT_JOGO,
				  HR_JOGO,
				  CG1.NM_GRUPO AS NM_GRUPO1, 
				  CG2.NM_GRUPO AS NM_GRUPO2
				FROM
				  TB_CAMPEONATO_JOGOS CJ
				  LEFT JOIN TB_CAMPEONATO_TIMES CT1 ON (CT1.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT1.CD_TIME = CJ.CD_TIME1)
			      LEFT JOIN TB_CAMPEONATO_GRUPOS CG1 ON (CG1.CD_GRUPO = CT1.CD_GRUPO AND CG1.CD_CAMPEONATO = CT1.CD_CAMPEONATO) 
				  LEFT JOIN TB_CAMPEONATO_TIMES CT2 ON (CT2.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT2.CD_TIME = CJ.CD_TIME2)
				  LEFT JOIN TB_CAMPEONATO_GRUPOS CG2 ON (CG2.CD_GRUPO = CT2.CD_GRUPO AND CG2.CD_CAMPEONATO = CT2.CD_CAMPEONATO) 
				WHERE
				  CJ.CD_CAMPEONATO = $campeonato and
				  CJ.NR_RODADA = $rodada and
				  CJ.NR_RODADA < 999
				ORDER BY
				  CJ.DT_JOGO
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetJogosPorData($campeonato, $dataInicial, $dataFinal)
		{
			$sql = "

			SELECT
			  CJ.CD_CAMPEONATO,
			  CJ.NR_RODADA,
			  CJ.NR_JOGO,
			  CJ.NR_CAMPO,
			  CJ.QT_GOLS1,
			  CJ.QT_GOLS2,
			  CJ.STATUS,
			  CT1.CD_TIME AS CD_TIME1,
			  CT1.NM_TIME AS NM_TIME1,
			  CT2.CD_TIME AS CD_TIME2,
			  CT2.NM_TIME AS NM_TIME2,
			  DT_JOGO,
			  HR_JOGO,
			  C.NM_CAMPEONATO,
			  CC.NM_CATEGORIA,
			  CC.CD_CATEGORIA,
			  CJ.CD_GRUPO,
			  CG1.NM_GRUPO AS NM_GRUPO1, 
			  CG2.NM_GRUPO AS NM_GRUPO2
			FROM
			  TB_CAMPEONATO_JOGOS CJ
			  LEFT JOIN TB_CAMPEONATO_TIMES CT1 ON (CT1.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT1.CD_TIME = CJ.CD_TIME1)
			  LEFT JOIN TB_CAMPEONATO_GRUPOS CG1 ON (CG1.CD_GRUPO = CT1.CD_GRUPO AND CG1.CD_CAMPEONATO = CT1.CD_CAMPEONATO) 
			  LEFT JOIN TB_CAMPEONATO_TIMES CT2 ON (CT2.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT2.CD_TIME = CJ.CD_TIME2)
			  LEFT JOIN TB_CAMPEONATO_GRUPOS CG2 ON (CG2.CD_GRUPO = CT2.CD_GRUPO AND CG2.CD_CAMPEONATO = CT2.CD_CAMPEONATO) 
			  LEFT JOIN TB_CAMPEONATO C ON (C.CD_CAMPEONATO = CJ.CD_CAMPEONATO)
			  LEFT JOIN TB_CAMPEONATO_CATEGORIAS CC ON (CC.CD_CATEGORIA = C.CD_CATEGORIA)
			WHERE
			  C.IN_ATIVO = 'T' AND
			  CJ.DT_JOGO >= '$dataInicial' AND
			  CJ.DT_JOGO <= '$dataFinal'
			ORDER BY
			  CJ.DT_JOGO, HR_JOGO DESC 			
			  
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetDatasDosJogos($campeonato)
		{
			$sql = "
				SELECT
				  CJ.DT_JOGO
				FROM
				  TB_CAMPEONATO_JOGOS CJ
				WHERE
				  CJ.CD_CAMPEONATO = $campeonato
				GROUP BY
				  CJ.DT_JOGO
				ORDER BY
				  CJ.DT_JOGO";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetDatasDosJogosAtivos()
		{
			$sql = "
				SELECT
				  CJ.DT_JOGO
				FROM
				  TB_CAMPEONATO_JOGOS CJ
				  INNER JOIN tb_campeonato C ON (C.CD_CAMPEONATO = CJ.CD_CAMPEONATO)
				WHERE
				  C.IN_ATIVO = 'T'
				GROUP BY
				  CJ.DT_JOGO
				ORDER BY
				  CJ.DT_JOGO";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetJogosDoTime($campeonato, $time)
		{
			$sql = "

				SELECT
				  CJ.CD_CAMPEONATO,
				  CJ.NR_RODADA,
				  CJ.NR_JOGO,
				  CJ.NR_CAMPO,
				  CJ.QT_GOLS1,
				  CJ.QT_GOLS2,
				  CJ.STATUS,
				  CT1.CD_TIME AS CD_TIME1,
				  CT2.CD_TIME AS CD_TIME2,
				  CT1.NM_TIME AS NM_TIME1,
				  CT2.NM_TIME AS NM_TIME2,
				  DT_JOGO,
				  HR_JOGO,
				  CG1.NM_GRUPO AS NM_GRUPO1, 
				  CG2.NM_GRUPO AS NM_GRUPO2
				FROM
				  TB_CAMPEONATO_JOGOS CJ
				  LEFT JOIN TB_CAMPEONATO_TIMES CT1 ON (CT1.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT1.CD_TIME = CJ.CD_TIME1)
				  LEFT JOIN TB_CAMPEONATO_GRUPOS CG1 ON (CG1.CD_GRUPO = CT1.CD_GRUPO AND CG1.CD_CAMPEONATO = CT1.CD_CAMPEONATO)
				  LEFT JOIN TB_CAMPEONATO_TIMES CT2 ON (CT2.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT2.CD_TIME = CJ.CD_TIME2)
				  LEFT JOIN TB_CAMPEONATO_GRUPOS CG2 ON (CG2.CD_GRUPO = CT2.CD_GRUPO AND CG2.CD_CAMPEONATO = CT2.CD_CAMPEONATO)
				WHERE
				  CJ.NR_RODADA < 999 and
				  CJ.CD_CAMPEONATO = $campeonato and
				  (CJ.CD_TIME1 = $time or CJ.CD_TIME2 = $time)
				ORDER BY
				  CJ.DT_JOGO
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetJogosDoTimeConfronto($campeonato, $jogo)
		{
			$sql = "
				SELECT
				  CJ.CD_CAMPEONATO,
				  CJ.NR_RODADA,
				  CJ.NR_JOGO,
				  CJ.NR_CAMPO,
				  CJ.QT_GOLS1,
				  CJ.QT_GOLS2,
				  CJ.STATUS,
				  CT1.CD_TIME AS CD_TIME1,
				  CT2.CD_TIME AS CD_TIME2,
				  CT1.NM_TIME AS NM_TIME1,
				  CT2.NM_TIME AS NM_TIME2,
				  DT_JOGO,
				  HR_JOGO,
				  CG1.NM_GRUPO AS NM_GRUPO1, 
				  CG2.NM_GRUPO AS NM_GRUPO2
				FROM
				  TB_CAMPEONATO_JOGOS CJ
				  LEFT JOIN TB_CAMPEONATO_TIMES CT1 ON (CT1.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT1.CD_TIME = CJ.CD_TIME1)
				  LEFT JOIN TB_CAMPEONATO_GRUPOS CG1 ON (CG1.CD_GRUPO = CT1.CD_GRUPO AND CG1.CD_CAMPEONATO = CT1.CD_CAMPEONATO)
				  LEFT JOIN TB_CAMPEONATO_TIMES CT2 ON (CT2.CD_CAMPEONATO = CJ.CD_CAMPEONATO AND CT2.CD_TIME = CJ.CD_TIME2)
				  LEFT JOIN TB_CAMPEONATO_GRUPOS CG2 ON (CG2.CD_GRUPO = CT2.CD_GRUPO AND CG2.CD_CAMPEONATO = CT2.CD_CAMPEONATO)
				WHERE
				  CJ.NR_JOGO = $jogo
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			$sql2 = "
				SELECT
				  E.NM_ENTIDADE,
				  COALESCE( (SELECT COUNT(S.QT_FALTAS_JUSTIF)     FROM TB_CAMPEONATO_SUMULAS S WHERE S.QT_FALTAS_JUSTIF = 'T' AND S.codigo = CS.codigo AND S.nr_jogo = CS.nr_jogo), 0) AS JUSTIFICADA,
				  COALESCE( (SELECT COUNT(S.QT_FALTAS_INJUST)     FROM TB_CAMPEONATO_SUMULAS S WHERE S.QT_FALTAS_INJUST = 'T' AND S.codigo = CS.codigo AND S.nr_jogo = CS.nr_jogo), 0) AS INJUSTIFICADA,
				  COALESCE( (SELECT COUNT(S.QT_CARTOES_AZUL)      FROM TB_CAMPEONATO_SUMULAS S WHERE S.QT_CARTOES_AZUL = 'T' AND  S.codigo = CS.codigo AND S.nr_jogo = CS.nr_jogo), 0) AS AZUL,
				  COALESCE( (SELECT COUNT(S.QT_CARTOES_AMARELO)   FROM TB_CAMPEONATO_SUMULAS S WHERE S.QT_CARTOES_AMARELO = 'T' AND S.codigo = CS.codigo AND S.nr_jogo = CS.nr_jogo), 0) AS AMARELO,
				  COALESCE( (SELECT COUNT(S.QT_CARTOES_VERMELHO)  FROM TB_CAMPEONATO_SUMULAS S WHERE S.QT_CARTOES_VERMELHO = 'T' AND S.codigo = CS.codigo AND S.nr_jogo = CS.nr_jogo), 0) AS VERMELHO,
				  COALESCE( (SELECT SUM(S.QT_GOLS_PRO)            FROM TB_CAMPEONATO_SUMULAS S WHERE S.codigo = CS.codigo AND S.nr_jogo = CS.nr_jogo), 0) AS GOLS,
				  CS.*
				FROM
				  TB_CAMPEONATO_SUMULAS CS
				  LEFT JOIN TB_ENTIDADE E ON (E.CODIGO = CS.CODIGO)
				WHERE
				  NR_JOGO = $jogo
				ORDER BY
				  CS.CD_TIME";

			$oConexao2 = new Conexao();
			$oConexao2->Conecta();
			$arr2 = $oConexao2->toArray($sql2);
			$oConexao2->Desconecta();

			$ret = array("resultado" => $arr, "sumula" => $arr2);

			return to_utf8( $ret );
		}
              
		function GetArtilheiro($campeonato)
		{
			$sql = "select CODIGO, NM_ENTIDADE, NM_TIME, QT_GOLS, QT_JOGOS, VL_MEDIA, CD_POSICAO from pr_campeonato_artilharia(". $campeonato .") order by qt_gols desc, vl_media desc, NM_ENTIDADE";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetGoleiroMenosVazado($campeonato)
		{
			$sql = "
				SELECT
				  *
				FROM
				  PR_CAMPEONATO_MENOS_VAZADO ($campeonato)
				ORDER BY
				  QT_GOLS, VL_MEDIA, NM_ENTIDADE";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetAtleta($time)
		{
			$sql = "
				SELECT
				  T1.NM_CAMPEONATO,
				  T1.CD_CATEGORIA,
				  T4.NM_CATEGORIA,
				  T3.NM_GRUPO,
				  T2.*,
				  T5.CODIGO,
				  T5.NR_FONE_RESIDENCIAL,
				  T5.NR_FONE_COMERCIAL,
				  T5.NR_CELULAR,
				  T5.E_MAIL,
				  T6.NR_COTA,
				  T6.DV_COTA,
				  T5.NM_APELIDO AS NM_ENTIDADE,
				  T6.DT_NASC,
				  T7.NM_POSICAO,
				  COALESCE( (SELECT COUNT(S.QT_CARTOES_AZUL)     FROM TB_CAMPEONATO_SUMULAS S WHERE S.QT_CARTOES_AZUL = 'T' AND S.CD_TIME = T2.CD_TIME AND T5.CODIGO = S.CODIGO), 0) AS AZUL,
				  COALESCE( (SELECT COUNT(S.QT_CARTOES_AMARELO)  FROM TB_CAMPEONATO_SUMULAS S WHERE S.QT_CARTOES_AMARELO = 'T' AND S.CD_TIME = T2.CD_TIME AND T5.CODIGO = S.CODIGO), 0) AS AMARELO,
				  COALESCE( (SELECT COUNT(S.QT_CARTOES_VERMELHO) FROM TB_CAMPEONATO_SUMULAS S WHERE S.QT_CARTOES_VERMELHO = 'T' AND S.CD_TIME = T2.CD_TIME AND T5.CODIGO = S.CODIGO), 0) AS VERMELHO,
				  COALESCE( (SELECT SUM(S.QT_GOLS_PRO)           FROM TB_CAMPEONATO_SUMULAS S WHERE S.CD_TIME = T2.CD_TIME AND T5.CODIGO = S.CODIGO), 0) AS GOLS
				FROM
				  TB_CAMPEONATO_TIMES T2
				  LEFT JOIN TB_CAMPEONATO_TIME_ATLETAS T5 ON (T5.CD_TIME = T2.CD_TIME)
				  LEFT JOIN TB_CAMPEONATO T1 ON (T2.CD_CAMPEONATO = T1.CD_CAMPEONATO)
				  LEFT JOIN TB_CAMPEONATO_GRUPOS T3 ON (T3.CD_GRUPO = T2.CD_GRUPO AND T3.CD_CAMPEONATO = T2.CD_CAMPEONATO)
				  LEFT JOIN TB_CAMPEONATO_CATEGORIAS T4 ON (T4.CD_CATEGORIA = T1.CD_CATEGORIA)
				  LEFT JOIN VW_SOCIO T6 ON (T6.CODIGO = T5.CODIGO)
				  LEFT JOIN TB_ATLETA_POSICAO T7 ON (T7.CD_POSICAO = T5.CD_POSICAO)
				WHERE
				  T2.CD_TIME = $time
				ORDER BY
				  NM_CAMPEONATO, NM_GRUPO, NM_TIME, NR_COTA";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}
	
		function GetCampeonatosAtivos()
		{
			$sql = "
				SELECT
				  C.*,
				  CC.CD_CATEGORIA,
				  CC.NM_CATEGORIA AS NOME_CATEGORIA
				FROM
				  TB_CAMPEONATO C
				  LEFT JOIN TB_CAMPEONATO_CATEGORIAS CC ON (CC.CD_CATEGORIA = C.CD_CATEGORIA)
				WHERE
				  C.IN_ATIVO = 'T'
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetCategorias()
		{
			$sql = "
				SELECT
				  CC.CD_CATEGORIA AS CD_CATEGORIA,
				  CC.NM_CATEGORIA AS NOME_CATEGORIA
				FROM
				  TB_CAMPEONATO_CATEGORIAS CC
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetPosicoesAtletas()
		{
			$sql = "
				SELECT
				  AP.CD_POSICAO AS CD_POSICAO,
				  AP.NM_POSICAO AS NOME
				FROM
				  TB_ATLETA_POSICAO AP
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetTodosCampeonatosAtivoSuasChaves()
		{
			$sql = "
				SELECT
				  C.CD_CAMPEONATO,
				  C.NM_CAMPEONATO AS NOME_CAMPEONATO,
				  CC.CD_CHAVE,
				  CC.NM_CHAVE AS NOME_CHAVE
				FROM
				  TB_CAMPEONATO C
				  LEFT JOIN TB_CAMPEONATO_CHAVES CC ON (C.CD_CAMPEONATO = CC.CD_CAMPEONATO)
				WHERE
				  C.IN_ATIVO = 'T'
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function GetCampeonatosAtivoSuasChaves($codigoCampeonato)
		{
			$sql = "
				SELECT
				  C.CD_CAMPEONATO,
				  C.NM_CAMPEONATO AS NOME_CAMPEONATO,
				  CC.CD_CHAVE,
				  CC.NM_CHAVE AS NOME_CHAVE
				FROM
				  TB_CAMPEONATO C
				  LEFT JOIN TB_CAMPEONATO_CHAVES CC ON (C.CD_CAMPEONATO = CC.CD_CAMPEONATO)
				WHERE
					C.CD_CAMPEONATO = $codigoCampeonato AND
					C.IN_ATIVO = 'T'
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		public function getRankingSocioPorCategoria($codigoSocio, $codigoCategoriaCampeonato)
        {
			$sql = " 
				SELECT
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  TD.NM_ENTIDADE AS NOME,
                  TD.DT_NASC AS DATA_NASCIMENTO,
                  TD.CODIGO AS N_SOCIO,
                  TD.FONE AS CONTATO,
                  TD.E_MAIL AS EMAIL,
                  TD.DT_CADASTRO AS DATA_INSCRICAO,
                  CASE
                    WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
                    ELSE '0'
                    END AS TITULAR,
                  TD.SEXO,
                  RS.NR_RANKING AS RANKING,
				  RS.ANO,
                  (SELECT FIRST 1 RS.NR_RANKING FROM TB_RANKING_SOCIO RS WHERE RS.CODIGO = TD.CODIGO ORDER BY RS.SEQUENCIA DESC) AS RANKING,
                  (SELECT TMP.IN_INTERNET FROM TB_TITULAR_DEPENDENTE TMP WHERE TMP.CODIGO = TD.CD_TITULAR) AS PUBLICAR
                FROM
                  VW_SOCIO TD
                  INNER JOIN TB_RANKING_SOCIO RS ON (RS.CODIGO = TD.CODIGO AND RS.CD_CATEGORIA = $codigoCategoriaCampeonato)
                WHERE
				  TD.CODIGO = $codigoSocio AND
                  RS.CD_CATEGORIA = $codigoCategoriaCampeonato AND
                  TD.ATIVO = 'A' AND
                  TD.STATUS = 'V'
                ORDER BY
                  TD.NM_ENTIDADE";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return $arr;
        }
		
		public function getRanking()
		{
			$sql = " 
			SELECT
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  TD.NM_ENTIDADE AS NOME,
                  TD.DT_NASC AS DATA_NASCIMENTO,
                  TD.CODIGO AS N_SOCIO,
                  TD.FONE AS CONTATO,
                  TD.E_MAIL AS EMAIL,
                  TD.DT_CADASTRO AS DATA_INSCRICAO,
                  CASE
                    WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
                    ELSE '0'
                    END AS TITULAR,
                  TD.SEXO,
                  RS.NR_RANKING AS RANKING,
				  RS.ANO,
                  (SELECT TMP.IN_INTERNET FROM TB_TITULAR_DEPENDENTE TMP WHERE TMP.CODIGO = TD.CD_TITULAR) AS PUBLICAR,
				  (SELECT FIRST 1 CTA.CD_POSICAO FROM TB_CAMPEONATO_TIME_ATLETAS CTA  WHERE CTA.CODIGO = TD.CODIGO ORDER BY CTA.CD_CAMPEONATO DESC) AS CD_POSICAO
                FROM
                  TB_RANKING_SOCIO RS 
                  INNER JOIN VW_SOCIO TD ON (RS.CODIGO = TD.CODIGO)
                WHERE
                  TD.ATIVO = 'A' AND
                  TD.STATUS = 'V'
                ORDER BY
                  TD.NM_ENTIDADE
			";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		public function getRankingPorAno($ano)
		{
			$sql = " 
			SELECT
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  TD.NM_ENTIDADE AS NOME,
                  TD.DT_NASC AS DATA_NASCIMENTO,
                  TD.CODIGO AS N_SOCIO,
                  TD.FONE AS CONTATO,
                  TD.E_MAIL AS EMAIL,
                  TD.DT_CADASTRO AS DATA_INSCRICAO,
                  CASE
                    WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
                    ELSE '0'
                    END AS TITULAR,
                  TD.SEXO,
                  RS.NR_RANKING AS RANKING,
				  RS.ANO,
                  (SELECT TMP.IN_INTERNET FROM TB_TITULAR_DEPENDENTE TMP WHERE TMP.CODIGO = TD.CD_TITULAR) AS PUBLICAR,
				  (SELECT FIRST 1 CTA.CD_POSICAO FROM TB_CAMPEONATO_TIME_ATLETAS CTA  WHERE CTA.CODIGO = TD.CODIGO ORDER BY CTA.CD_CAMPEONATO DESC) AS CD_POSICAO
                FROM
                  TB_RANKING_SOCIO RS 
                  INNER JOIN VW_SOCIO TD ON (RS.CODIGO = TD.CODIGO)
                WHERE
				  RS.ANO = $ano AND
                  TD.ATIVO = 'A' AND
                  TD.STATUS = 'V'
                ORDER BY
                  TD.NM_ENTIDADE
			";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}
	
		public function getRankingPorCategoria($codigoCategoriaCampeonato)
		{
			$sql = " 
			SELECT
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  TD.NM_ENTIDADE AS NOME,
                  TD.DT_NASC AS DATA_NASCIMENTO,
                  TD.CODIGO AS N_SOCIO,
                  TD.FONE AS CONTATO,
                  TD.E_MAIL AS EMAIL,
                  TD.DT_CADASTRO AS DATA_INSCRICAO,
                  CASE
                    WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
                    ELSE '0'
                    END AS TITULAR,
                  TD.SEXO,
                  RS.NR_RANKING AS RANKING,
				  RS.ANO,
                  (SELECT TMP.IN_INTERNET FROM TB_TITULAR_DEPENDENTE TMP WHERE TMP.CODIGO = TD.CD_TITULAR) AS PUBLICAR,
				  (SELECT FIRST 1 CTA.CD_POSICAO FROM TB_CAMPEONATO_TIME_ATLETAS CTA  WHERE CTA.CODIGO = TD.CODIGO ORDER BY CTA.CD_CAMPEONATO DESC) AS CD_POSICAO
                FROM
                  VW_SOCIO TD
                  INNER JOIN TB_RANKING_SOCIO RS ON (RS.CODIGO = TD.CODIGO AND RS.CD_CATEGORIA = $codigoCategoriaCampeonato)
                WHERE
                  RS.CD_CATEGORIA = $codigoCategoriaCampeonato AND
                  TD.ATIVO = 'A' AND
                  TD.STATUS = 'V'
                ORDER BY
                  TD.NM_ENTIDADE
			";	

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function setNullTituloExcluidoPorSocio($codigoSocio)
		{
			$sql = "
				 UPDATE
				   TB_CAMPEONATO_INSCRICAO SET NR_LANCAMENTO = NULL
				 WHERE
				   CODIGO = $codigoSocio AND
				   NR_LANCAMENTO =
				   (
								SELECT
								  FIRST 1 PR.NR_LANCAMENTO
								FROM
								  TB_CAMPEONATO_INSCRICAO CI
								  LEFT JOIN TB_PAGAR_RECEBER_NV PR ON (PR.NR_LANCAMENTO = CI.NR_LANCAMENTO)
								WHERE
					              CI.CODIGO = $codigoSocio AND
								  TB_CAMPEONATO_INSCRICAO.NR_LANCAMENTO = CI.NR_LANCAMENTO AND
								  PR.ST_LANCAMENTO = 'D' 
					)
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$oConexao->Execute($sql);
			$oConexao->Commit();
			$oConexao->Desconecta();
		}

		function setNullTituloExcluidoPorInscricao($codigoInscricao)
		{
			$sql = "
				 UPDATE
				   TB_CAMPEONATO_INSCRICAO SET NR_LANCAMENTO = NULL
				 WHERE
				   CD_CAMPEONATO_INSCRICAO = $codigoInscricao AND
				   NR_LANCAMENTO =
				   (
								SELECT
								  FIRST 1 PR.NR_LANCAMENTO
								FROM
								  TB_CAMPEONATO_INSCRICAO CI
								  LEFT JOIN TB_PAGAR_RECEBER_NV PR ON (PR.NR_LANCAMENTO = CI.NR_LANCAMENTO)
								WHERE
					              CI.CD_CAMPEONATO_INSCRICAO = $codigoInscricao AND
								  TB_CAMPEONATO_INSCRICAO.NR_LANCAMENTO = CI.NR_LANCAMENTO AND
								  PR.ST_LANCAMENTO = 'D' 
					)
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$oConexao->Execute($sql);
			$oConexao->Commit();
			$oConexao->Desconecta();
		}

		function UltimaInscricaoCampeonato($codigo)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 
			
			$sql = "
                SELECT
                  first 1
                  CI.*,
                  PR.DT_BAIXA,
                  CASE
                    WHEN (NOT PR.DT_BAIXA IS NULL) AND (PR.ST_LANCAMENTO IS NULL) THEN 'PAGO'
                    ELSE 'ABERTO'
                  END AS SITUACAOPAGAMENTO
                FROM
                  TB_CAMPEONATO_INSCRICAO CI
                  LEFT JOIN TB_PAGAR_RECEBER_NV PR ON (PR.NR_LANCAMENTO = CI.NR_LANCAMENTO)
                WHERE
                  CI.CODIGO = '". $codigo ."'
                order by
                  CI.CD_CAMPEONATO_INSCRICAO DESC ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function isInscricaoCampeonatoPorInscricao($codigoInscricao)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 

			$sql = "
			
				SELECT
				  CI.*,
				  PR.DT_BAIXA,
				  CASE
				    WHEN (NOT PR.DT_BAIXA IS NULL) AND (PR.ST_LANCAMENTO IS NULL) THEN 'PAGO'
				    ELSE 'ABERTO'
				  END AS SITUACAOPAGAMENTO
				FROM
				  TB_CAMPEONATO_INSCRICAO CI
				  LEFT JOIN TB_PAGAR_RECEBER_NV PR ON (PR.NR_LANCAMENTO = CI.NR_LANCAMENTO)
				WHERE
				  CI.CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."'  					  
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function isInscricaoCampeonato($codigo, $codigoCampeonato)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 

			$sql = "
			
				SELECT
				  CI.*,
				  PR.DT_BAIXA,
				  CASE
				    WHEN (NOT PR.DT_BAIXA IS NULL) AND (PR.ST_LANCAMENTO IS NULL) THEN 'PAGO'
				    ELSE 'ABERTO'
				  END AS SITUACAOPAGAMENTO
				FROM
				  TB_CAMPEONATO_INSCRICAO CI
				  LEFT JOIN TB_PAGAR_RECEBER_NV PR ON (PR.NR_LANCAMENTO = CI.NR_LANCAMENTO)
				WHERE
				  CI.CD_CAMPEONATO = '". $codigoCampeonato ."'  AND
				  CI.CODIGO = '". $codigo ."'
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function isInscricaoCampeonatoPorCategoria($codigo, $codigoCampeonato, $codigoCategoria)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 

			$sql = "
			
				SELECT
				  CI.*,
				  PR.DT_BAIXA,
				  CASE
				    WHEN (NOT PR.DT_BAIXA IS NULL) AND (PR.ST_LANCAMENTO IS NULL) THEN 'PAGO'
				    ELSE 'ABERTO'
				  END AS SITUACAOPAGAMENTO
				FROM
				  TB_CAMPEONATO_INSCRICAO CI
				  LEFT JOIN TB_PAGAR_RECEBER_NV PR ON (PR.NR_LANCAMENTO = CI.NR_LANCAMENTO)
				WHERE
					CI.CD_CAMPEONATO = '". $codigoCampeonato ."'  AND
					CI.CD_CATEGORIA = '". $codigoCategoria ."' AND
					CI.CODIGO = '". $codigo ."'
			
			";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function setStatusInscricaoCampeonato($codigoInscricao, $status)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 
			
			$sql = "UPDATE TB_CAMPEONATO_INSCRICAO SET STATUS = '". $status ."' WHERE CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."'";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$oConexao->Execute($sql);
			$afetados = $oConexao->RegistrosAfetados();
			$oConexao->Commit();
			$oConexao->Desconecta();

			if ($afetados > 0) 
			{
				$sql = "SELECT * FROM TB_CAMPEONATO_INSCRICAO WHERE CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."' ";
				$oConexao->Conecta();
				$arr = $oConexao->toArray($sql);
				$oConexao->Desconecta();
				return to_utf8($arr) ;
			}
			else
			{
				return -1;
			}
		}

		function SaveInscricaoCampeonato($codigo, $codigoCampeonato, $codigoCategoria, $codigoTime, $codigoChave, $codigoPosicao, $observacao)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 

			$sql = "SELECT * FROM TB_CAMPEONATO_INSCRICAO WHERE CD_CAMPEONATO = '". $codigoCampeonato ."' AND CODIGO = '". $codigo ."' ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			if (count($arr) == 0)
			{
				$dataInclusao = Date('Y-m-d');
				$horaInclusao = Date('h:m:s');

				$sql = "
					INSERT INTO TB_CAMPEONATO_INSCRICAO 
					(CODIGO, CD_CAMPEONATO, CD_POSICAO, CD_TIME, CD_CHAVE, CD_CATEGORIA, OBSERVACAO, DATAINCLUSAO, HORAINCLUSAO, STATUS) 
					VALUES 
					('". $codigo ."','". $codigoCampeonato ."','". $codigoPosicao ."','". $codigoTime ."','". $codigoChave ."','". $codigoCategoria ."','". $observacao  ."','". $dataInclusao ."','". $horaInclusao ."',  '". 1 ."')
				";

				$oConexao = new Conexao();
				$oConexao->Conecta();
				$oConexao->Execute($sql);
				$afetados = $oConexao->RegistrosAfetados();


				$oConexao->Commit();
				$oConexao->Desconecta();

				if ($afetados > 0) 
				{
					$sql = "SELECT FIRST 1 * FROM TB_CAMPEONATO_INSCRICAO WHERE CODIGO = $codigo ORDER BY CD_CAMPEONATO_INSCRICAO DESC";

					$oConexao = new Conexao();
					$oConexao->Conecta();
					$arr = $oConexao->toArray($sql);
					$oConexao->Desconecta();

					return to_utf8($arr) ;
				}
				else
				{
					return -1;
				}
			}
			return -1;
		}

		function SaveObservacao($codigoInscricao, $observacao)
		{
			$sql = "UPDATE TB_CAMPEONATO_INSCRICAO SET OBSERVACAO = '". $observacao  ."' WHERE CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."' ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$oConexao->Execute($sql);
			$afetados = $oConexao->RegistrosAfetados();
			$oConexao->Commit();
			$oConexao->Desconecta();
			
			if ($afetados > 0) {
				return 1;
			} else {
				return 0;
			}
		}
		
		function SavePosicao($codigoInscricao, $codigoPosicao)
		{
			$sql = "UPDATE TB_CAMPEONATO_INSCRICAO SET CD_POSICAO = '". $codigoPosicao  ."' WHERE CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."' ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$oConexao->Execute($sql);
			$afetados = $oConexao->RegistrosAfetados();
			$oConexao->Commit();
			$oConexao->Desconecta();
			
			if ($afetados > 0) {
				return 1;
			} else {
				return 0;
			}
		}
		
		function SaveCategoria($codigoInscricao, $codigoCategoria)
		{
			$sql = "UPDATE TB_CAMPEONATO_INSCRICAO SET CD_CATEGORIA = '". $codigoCategoria  ."' WHERE CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."' ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$oConexao->Execute($sql);
			$afetados = $oConexao->RegistrosAfetados();
			$oConexao->Commit();
			$oConexao->Desconecta();
			
			if ($afetados > 0) {
				return 1;
			} else {
				return 0;
			}
		}

		function UpdateInscricaoCampeonato($codigoInscricao, $codigoCampeonato, $codigoCategoria, $codigoTime, $codigoChave, $codigoPosicao, $observacao)
		{
			$sql = "";
			$sql .= " UPDATE TB_CAMPEONATO_INSCRICAO SET ";
					
			if (!empty($codigoCampeonato)) 
				$sql .= " CD_CAMPEONATO = '". $codigoCampeonato ."', ";
					
			if (!empty($codigoCategoria)) 
				$sql .= " CD_CATEGORIA = '". $codigoCategoria ."', ";
					
			if (!empty($codigoTime)) 
				$sql .= " CD_TIME = '". $codigoTime ."', ";
					
			if (!empty($codigoChave)) 
				$sql .= " CD_CHAVE = '". $codigoChave  ."', ";
					
			if (!empty($codigoPosicao)) 
				$sql .= " CD_POSICAO = '". $codigoPosicao ."', ";
					
			if (!empty($observacao)) 
				$sql .= " OBSERVACAO = '". $observacao  ."', ";
			
			$sql .= "   DATAINCLUSAO = DATAINCLUSAO ";
			$sql .= " WHERE CD_CAMPEONATO_INSCRICAO = '". $codigoInscricao ."' ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$oConexao->Execute($sql);
			$afetados = $oConexao->RegistrosAfetados();
			$oConexao->Commit();
			$oConexao->Desconecta();
			
			if ($afetados > 0) {
				return 1;
			} else {
				return 0;
			}
		}		

		function getAllInscricaoCampeonato($codigoCampeonato)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 

			$sql = "
			
                SELECT
                  CI.*,
                  TD.NR_COTA AS TITULO,
                  TD.DV_COTA AS SERIE,
                  E.NM_ENTIDADE,
                  PF.DT_NASC AS DATA_NASCIMENTO,
                  PF.CPF,
                  TD.FONE AS CONTATO,
                  TD.E_MAIL AS EMAIL,
                  TD.CODIGO AS N_SOCIO,
                  CASE
                    WHEN TD.CD_TITULAR = TD.CODIGO THEN '1'
                    ELSE '0'
                    END AS TITULAR,
                  PF.SEXO,
                  (SELECT FIRST 1 RS.NR_RANKING FROM TB_RANKING_SOCIO RS WHERE RS.CODIGO = TD.CODIGO ORDER BY RS.SEQUENCIA DESC) AS RANKING,
                  PR.DT_BAIXA,
                  CASE
                    WHEN (NOT PR.DT_BAIXA IS NULL) AND (PR.ST_LANCAMENTO IS NULL) THEN 'PAGO'
                    ELSE 'ABERTO'
                  END AS SITUACAOPAGAMENTO
                FROM
                  TB_CAMPEONATO_INSCRICAO CI
                  LEFT JOIN TB_ENTIDADE E ON (E.CODIGO = CI.CODIGO)
                  LEFT JOIN TB_TITULAR_DEPENDENTE TD ON (TD.CODIGO = E.CODIGO)
                  LEFT JOIN TB_PESSOA_FISICA PF ON (PF.CODIGO = E.CODIGO)
                  LEFT JOIN TB_PAGAR_RECEBER_NV PR ON (PR.NR_LANCAMENTO = CI.NR_LANCAMENTO)
                WHERE
                  CI.CD_CAMPEONATO = '". $codigoCampeonato ."' ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			return to_utf8($arr) ;
		}

		function SaveInscricaoCampeonato2($codigo, $codigoCampeonato, $codigoCategoria, $codigoTime, $codigoChave, $codigoPosicao, $observacao, $grupo)
		{
			// STATUS: 
			// 1 - SOLICITADO     
			// 2 - CONFIRMADO     
			// 3 - RECUSADO 

			$sql = "SELECT * FROM TB_CAMPEONATO_INSCRICAO WHERE CD_CAMPEONATO = '". $codigoCampeonato ."' AND CODIGO = '". $codigo ."' ";

			$oConexao = new Conexao();
			$oConexao->Conecta();
			$arr = $oConexao->toArray($sql);
			$oConexao->Desconecta();

			if (count($arr) == 0)
			{
				$dataInclusao = Date('Y-m-d');
				$horaInclusao = Date('h:m:s');

				$sql = "
					INSERT INTO TB_CAMPEONATO_INSCRICAO 
					(CODIGO, CD_CAMPEONATO, CD_POSICAO, CD_TIME, CD_CHAVE, CD_CATEGORIA, OBSERVACAO, DATAINCLUSAO, HORAINCLUSAO, STATUS, GRUPO) 
					VALUES 
					('". $codigo ."','". $codigoCampeonato ."','". $codigoPosicao ."','". $codigoTime ."','". $codigoChave ."','". $codigoCategoria ."','". $observacao  ."','". $dataInclusao ."','". $horaInclusao ."',  '". 1 ."','". $grupo  ."')
				";

				$oConexao = new Conexao();
				$oConexao->Conecta();
				$oConexao->Execute($sql);
				$afetados = $oConexao->RegistrosAfetados();
				$oConexao->Commit();
				$oConexao->Desconecta();

				if ($afetados > 0) 
				{
					$sql = "SELECT FIRST 1 * FROM TB_CAMPEONATO_INSCRICAO WHERE CODIGO = $codigo ORDER BY CD_CAMPEONATO_INSCRICAO DESC";

					$oConexao = new Conexao();
					$oConexao->Conecta();
					$arr = $oConexao->toArray($sql);
					$oConexao->Desconecta();

					return to_utf8($arr) ;
				}
				else
				{
					return -1;
				}
			}
			return -1;
		}
		
		public function DownloadFoto($codigo)
		{
			$codigo = str_pad($codigo, 8, "0", STR_PAD_LEFT);
			$sql = "SELECT * FROM FOTOS WHERE CODIGOINTEGRACAO = '$codigo' AND ATIVO = 1 ";
			$oConexao = new Conexao();
			$oConexao->dataBase = "FOTOS.FDB";
			$oConexao->Conecta();
			$img = $oConexao->loadBlob($sql, "ARQUIVO");
			$oConexao->Desconecta();	
			return base64_encode($img);
		}
	}
	
		
?>